/***************************************************************************
*   Copyright (C) 2003-2004 by Hideki Ikemoto                             *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#include "access.h"

#include "thread.h"
#include "cache.h"
#include "kita_misc.h"
#include "account.h"

#include <config.h>

#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>

#include <kurl.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <kprotocolmanager.h>

#include <kio/slaveconfig.h>
#include <kio/netaccess.h>
#include <kio/jobclasses.h>
#include <kio/job.h>

#include <qregexp.h>
#include <qfile.h>
#include <qmessagebox.h>

using namespace Kita;

QString Access::getcache()
{
    QString cachePath = Kita::Cache::getPath( m_datURL );
    m_orgData = QString::null;

    if ( cachePath != QString::null ) {
        QFile file( cachePath );
        if ( file.open( IO_ReadOnly ) ) {
            m_orgData += file.readAll();
            file.close();
        }
    }

    return m_orgData;
}

// å˽񤭹ߡ
void Access::writeCacheData()
{
    if ( m_invalidDataReceived ) return ;
    if ( m_threadData == QString::null ) return ;

    m_orgData += m_threadData;

    QString cachePath = Kita::Cache::getPath( m_datURL );
    if ( cachePath != QString::null ) {
        FILE * fs = fopen( QFile::encodeName( cachePath ), "w" );
        if ( !fs ) return ;

        fwrite( m_orgData, m_orgData.length(), 1, fs );
        fclose( fs );
    }

    return ;
}

QString Access::getupdate()
{
    QString getURL = m_datURL.url();
    if ( Kita::boardType( getURL ) == Board_MachiBBS ) {
        getURL = Kita::datToThread( getURL );
    }

    QString retstr;
    m_threadData = "";
    m_firstReceive = FALSE;
    m_invalidDataReceived = FALSE;

    if ( KURL( getURL ).protocol() != "k2ch" ) {
        KIO::SlaveConfig::self() ->setConfigData( "http",
                KURL( getURL ).host(),
                "UserAgent",
                QString( "Monazilla/1.00 (Kita/%1)" ).arg( VERSION ) );
    }

    KIO::TransferJob* job = KIO::get( getURL, true, false );
    m_currentJob = job;

    connect( job, SIGNAL( data( KIO::Job*, const QByteArray& ) ),
             SLOT( slotReceiveThreadData( KIO::Job*, const QByteArray& ) ) );
    connect( job, SIGNAL( result( KIO::Job* ) ), SLOT( slotThreadResult( KIO::Job* ) ) );

    // use 'HTTP-Headers' metadata.
    job->addMetaData( "PropagateHttpHeader", "true" );
    if ( ! m_orgData.isNull() ) {
        m_firstReceive = TRUE; /* remove first char. see also slotReceiveThreadData() */
        job->addMetaData( "resume", QString::number( m_orgData.length() - 1 ) );
        job->addMetaData( "AllowCompressedPage", "false" );
    }

    return QString::null; /* dummy */
}

void Access::make_cacheDir( const KURL& url )
{
    // mkdir: $(KDRDIR)/share/cache/kita/pc.2ch.net/linux/xxxx.dat
    // ξ硢kita, pc.2ch.net, linux
    // TODO: 3ؤޤǤбƤʤΤʤȤ롣
    QString cachePath = Kita::Cache::getPath( url );
    KURL cacheDir = KURL( cachePath, "." );
    KURL cacheDir2 = KURL( cacheDir, ".." );
    KURL cacheDir3 = KURL( cacheDir2, ".." );
    if ( !KIO::NetAccess::exists( cacheDir3 ) ) {
        KIO::NetAccess::mkdir( cacheDir3 );
    }
    if ( !KIO::NetAccess::exists( cacheDir2 ) ) {
        KIO::NetAccess::mkdir( cacheDir2 );
    }
    if ( !KIO::NetAccess::exists( cacheDir ) ) {
        KIO::NetAccess::mkdir( cacheDir );
    }
}

void Access::slotThreadResult( KIO::Job* job )
{
    m_currentJob = 0;
    if ( job->error() ) {
        job->showErrorDialog();
    } else {
        m_header = job->queryMetaData( "HTTP-Headers" );
    }

    if ( !m_invalidDataReceived && m_threadData.length() ) {
        if ( Kita::boardType( m_datURL.url() ) == Board_MachiBBS ) {
            // TODO: need to refactoring.
            m_threadData = Kita::parse_machibbs_dat( m_threadData );
            KURL url = m_datURL;
            make_cacheDir( url );
            writeCacheData();
            emit receiveData( m_threadData );
        } else {
            KURL url = m_datURL;
            make_cacheDir( url );
            writeCacheData();
        }
    }
    emit finishLoad();
}

void Access::slotReceiveThreadData( KIO::Job*, const QByteArray& data )
{
    QString cstr( data );

    if ( ( m_orgData != QString::null && responseCode() != 206 )
            || ( m_firstReceive && cstr[ 0 ] != '\n' )
            || ( m_orgData == QString::null && responseCode() != 200 )
       ) m_invalidDataReceived = TRUE;

    if ( m_invalidDataReceived ) return ;

    /* If this is the first call at resumption, remove LF at head. */
    if ( m_firstReceive ) {
        cstr = cstr.mid( 1 );
    }
    m_firstReceive = FALSE;
    m_threadData += cstr ;
    if ( Kita::boardType( m_datURL.url() ) != Board_MachiBBS ) {
        emit receiveData( cstr );
    }
}


void Access::killJob()
{
    if ( m_currentJob ) m_currentJob->kill();
}

void Access::stopJob()
{
    if ( m_currentJob ) m_currentJob->kill( FALSE ); /* emit result signal */
}

int Access::serverTime()
{
    if ( m_currentJob ) m_header = m_currentJob->queryMetaData( "HTTP-Headers" );
    // parse HTTP headers
    QStringList headerList = QStringList::split( "\n", m_header );
    QRegExp regexp( "Date: (...), (..) (...) (....) (..:..:..) .*" );
    QString dateStr = headerList.grep( regexp ) [ 0 ];
    if ( regexp.search( dateStr ) == -1 ) {
        // invalid date format
        return QDateTime::currentDateTime().toTime_t();
    } else {
        // I hate this format ;p
        QString usLocalDateStr = regexp.cap( 1 ) + " " + regexp.cap( 3 ) + " " +
                                 regexp.cap( 2 ) + " " + regexp.cap( 5 ) + " " +
                                 regexp.cap( 4 );

        // 1970/01/01 00:00:00 GMT
        QDateTime zeroTime( QDate( 1970, 1, 1 ), QTime( 0, 0 ) );
        return zeroTime.secsTo( QDateTime::fromString( usLocalDateStr ) );
    }
}

int Access::responseCode()
{
    if ( m_currentJob ) m_header = m_currentJob->queryMetaData( "HTTP-Headers" );
    // parse HTTP headers
    QStringList headerList = QStringList::split( "\n", m_header );
    QRegExp regexp( "HTTP/1\\.[01] ([0-9]+) .*" );
    QString dateStr = headerList.grep( regexp ) [ 0 ];
    if ( regexp.search( dateStr ) == -1 ) {
        // invalid response
        return 0;
    } else {
        return regexp.cap( 1 ).toInt();
    }
}

bool Access::deleteLog( const Thread* thread )
{
    KURL url = thread->datURL();
    QString str = Kita::Cache::getPath( url );
    return KIO::NetAccess::del( str );
}

//
// access offlaw.cgi
//
QString OfflawAccess::get()
{
    QString getURL = Kita::datToOfflaw( m_datURL.url() );
    KURL kgetURL( getURL );
    kgetURL.addQueryItem( "sid", Account::getSessionID() );

    QString retstr;
    m_threadData = "";
    m_invalidDataReceived = FALSE;

    KIO::SlaveConfig::self() ->setConfigData( "http",
            KURL( getURL ).host(),
            "UserAgent",
            QString( "Monazilla/1.00 (Kita/%1)" ).arg( VERSION ) );

    KIO::TransferJob* job = KIO::get( kgetURL, true, false );
    m_currentJob = job;

    connect( job, SIGNAL( data( KIO::Job*, const QByteArray& ) ),
             SLOT( slotReceiveThreadData( KIO::Job*, const QByteArray& ) ) );
    connect( job, SIGNAL( result( KIO::Job* ) ), SLOT( slotThreadResult( KIO::Job* ) ) );

    // use 'HTTP-Headers' metadata.
    job->addMetaData( "PropagateHttpHeader", "true" );

    return QString::null; /* dummy */
}

void OfflawAccess::slotThreadResult( KIO::Job* job )
{
    m_currentJob = 0;
    if ( job->error() ) {
        job->showErrorDialog();
    } else {
        m_header = job->queryMetaData( "HTTP-Headers" );
    }

    if ( !m_invalidDataReceived && m_threadData.length() ) {
        KURL url = m_datURL;
        make_cacheDir( url );
        writeCacheData();
    }
    emit finishLoad();
}

void OfflawAccess::slotReceiveThreadData( KIO::Job*, const QByteArray& data )
{
    QString cstr( data );

    if ( ( m_orgData != QString::null && responseCode() != 206 )
            || ( m_orgData == QString::null && responseCode() != 200 ) ) {
        m_invalidDataReceived = TRUE;
    }

    if ( m_invalidDataReceived ) return ;

    // "+OK ....../1024K\tLocation:temp/\n"
    if ( m_threadData.isEmpty() && cstr[0] == '+' ) {
        // skip first line.
        int index = cstr.find( '\n' );
        cstr = cstr.mid( index + 1 );
    }
    m_threadData += cstr ;
    emit receiveData( cstr );
}

#include "access.moc"
