/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto, 2004 by 421                     *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITAWRITETABWIDGET_H
#define KITAWRITETABWIDGET_H

#include "kitatabwidgetbase.h"

class KitaWriteDialog;

/*-----------------------------------------------*/    


class KitaWriteTabWidget : public KitaTabWidgetBase
{
    Q_OBJECT
	
public:
    KitaWriteTabWidget( QWidget* parent = 0, const char* name = 0, WFlags f = 0 );
    ~KitaWriteTabWidget();

public slots:
    void slotShowWriteView( const KURL& url, const QString& resStr, const QString& mailAddr);
    void slotCloseWriteTab( const KURL& url ); 
    
private:
    void connectSignals(); 
    KitaWriteDialog* findWriteView( const KURL& url );
    KitaWriteDialog* isWriteView( QWidget* w );

private slots:
    void slotChangeWriteTab( const KURL& url );
    
protected:
    virtual void deleteWidget( QWidget* w );
};


/*--------------------------------------------------*/


class KitaWriteTabBar : public KitaTabBarBase
{
    Q_OBJECT

public:
    KitaWriteTabBar( QWidget* parent = 0, const char* name = 0 );
    ~KitaWriteTabBar();
};


/*------------------------------------------------------------*/


class KitaWriteDock : public KitaDockWidgetBase{

    Q_OBJECT
	KitaWriteTabWidget* m_writeTab;
	
public:
    KitaWriteDock( KDockManager* dockManager,
	    const char* name,
	    const QPixmap &pixmap,
	    QWidget* parent = 0L,
	    const QString& strCaption = QString::null,
	    const QString& strTabPageLabel = QString::fromLatin1( " " ),
	    WFlags f = 0);
    ~KitaWriteDock();

    KitaWriteTabWidget* setup();

public slots:
    void slotShowWriteView( const KURL& url, const QString& resStr, const QString& mailAddr);
};



#endif
