/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITASUBJECTTABWIDGET_H
#define KITASUBJECTTABWIDGET_H

#include "kitatabwidgetbase.h"

#include "favoritelistview.h"
#include "kitasubjectview.h"

/**
@author Hideki Ikemoto
*/
class KitaSubjectTabWidget : public KitaTabWidgetBase
{
    Q_OBJECT

public:
    KitaSubjectTabWidget( QWidget* parent = 0, const char* name = 0, WFlags f = 0 );
    ~KitaSubjectTabWidget();

public slots:
    void loadBoard( const QString&, bool withNewTab = false );

private:
    FavoriteListView* m_favoriteList;
    KitaSubjectView* m_latestView;
    QPtrList<KitaSubjectView> m_viewList;
    void connectSignals( Kita::ThreadListView* );
    KitaSubjectView* findView( const QString& boardURL );
    KitaSubjectView* isSubjectView( QWidget* w );
    void setupActions();

private slots:
    void slotCurrentChanged( QWidget* widget );
    void slotReloadButton();
    void slotFocusSearchCombo();


protected:
    virtual void deleteWidget( QWidget* w );

signals:
    void showThreadRequested( const QString&, bool withNewTab );
};

/*--------------------------------------------------*/

class SubjectTabBar : public KitaTabBarBase
{
    Q_OBJECT

public:
    SubjectTabBar( QWidget* parent = 0, const char* name = 0 );
    ~SubjectTabBar();

private:
    virtual void showPopupMenu( int idx, QPoint global );

};


/*--------------------------------------------------*/


class KitaSubjectDock : public KitaDockWidgetBase
{

    Q_OBJECT
    KitaSubjectTabWidget* m_subjectTab;
public:
    KitaSubjectDock( KDockManager* dockManager,
                     const char* name,
                     const QPixmap &pixmap,
                     QWidget* parent = 0L,
                     const QString& strCaption = QString::null,
                     const QString& strTabPageLabel = QString::fromLatin1( " " ),
                     WFlags f = 0 );
    ~KitaSubjectDock();

    KitaSubjectTabWidget* setup();

public slots:
    void slotLoadBoard( const QString& boardURL, bool withNewTab );
};



#endif
