/***************************************************************************
*   Copyright (C) 2004 by Hideki Ikemoto , (c) 2004 by 421                *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITABOARDTABWIDGET_H
#define KITABOARDTABWIDGET_H

#include "kitatabwidgetbase.h"

class KitaBoardView;
class QFont;

/*------------------------------------------------*/


class KitaBoardTabWidget : public KitaTabWidgetBase
{
    Q_OBJECT
    
public:
    KitaBoardTabWidget( QWidget* parent, const char* name = 0, WFlags fl = 0 );
    ~KitaBoardTabWidget();
    
public slots:
    void loadBoardList();
    void setFont( const QFont& font );
    
protected:
    virtual void deleteWidget( QWidget* w );
};


/*--------------------------------------------------*/


class KitaBoardDock : public KitaDockWidgetBase{

    Q_OBJECT
	KitaBoardTabWidget* m_boardTab;
public:
    KitaBoardDock( KDockManager* dockManager,
	    const char* name,
	    const QPixmap &pixmap,
	    QWidget* parent = 0L,
	    const QString& strCaption = QString::null,
	    const QString& strTabPageLabel = QString::fromLatin1( " " ),
	    WFlags f = 0);
    ~KitaBoardDock();

    KitaBoardTabWidget* setup();
};



#endif
