/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.resource.text;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import kinugasa.resource.Nameable;

/**
 * "vf"NX́AXML1̃GgɑΉ܂.
 * <br>
 * vfƂ͎̂悤ȍ\łB<br>
 * &lt;elementName attributeName=attributeValue&gt;<br>
 * &lt;contentElement&gt;<br>
 * &lt;/contentElement&gt;<br>
 * value<br>
 * &lt;/elementName attributeName=attributeValue&gt;<br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/03/15_7:07:44.<br>
 * @author dra0211 ( <a href="mailto:d0211@live.jp">d0211@live.jp</a>&nbsp;).<br>
 * <br>
 */
public class XMLElement implements Nameable{

	/** ̗vf̖Oł. */
	private String name;
	/** ̗vf̓ɐݒuꂽvf̃}bvł, */
	private Map<String, List<XMLElement>> content;
	/** ̗vfł. */
	private XMLAttributeStorage attributes;
	/** ̗vf̓ɒڏꂽeLXgł. */
	private String value;

	/**
	 * q̗vfȂvf쐬܂.
	 * @param name ̗vf̖OłB<br>
	 * @param attributes ̗vfłB<br>
	 * @param value ̗vf̃eLXgłB<br>
	 */
	public XMLElement(String name, XMLAttributeStorage attributes, String value) {
		this.name = name;
		this.attributes = attributes;
		this.value = value;
	}

	/**
	 * qvfvf쐬܂.
	 * @param name ̗vf̖OłB<br>
	 * @param content ̃Ggq̃Gg𑗐M܂B<br>
	 * @param attributes ̗vfłB<br>
	 * @param value ̗vf̃eLXgłB<br>
	 */
	public XMLElement(String name, Map<String, List<XMLElement>> content, XMLAttributeStorage attributes, String value) {
		this.name = name;
		this.content = content;
		this.attributes = attributes;
		this.value = value;
	}

	/**
	 * ̗vf̃eLXg擾܂.
	 * @return ̗vfeLXgԂ܂BeLXgȂꍇ́ANULLԂ܂B<br>
	 */
	public String getValue() {
		return value;
	}

	/**
	 * ̗vfeLXgĂ邩܂.
	 * @return eLXgꍇtrueԂ܂B̖߂lgetValue()!=nullƓłB<br>
	 */
	public boolean hasValue() {
		return value != null;
	}

	/**
	 * ̗vfɐݒ肳ꂽ擾܂.
	 * @return i[Xg[WԂ܂B<br>
	 */
	public XMLAttributeStorage getAttributes() {
		return attributes;
	}

	/**
	 * ̗vfq̗vf擾܂.
	 * @return q̗vfԂ܂Bq̗vfݒ肳ĂȂꍇnullԂ܂B<br>
	 */
	public Map<String, List<XMLElement>> getContent() {
		return content;
	}

	/**
	 * w肵Oq̗vfԂ܂.
	 * @param name vf̖Ow肵܂B<br>
	 * @return w肵O̗vf̃XgԂ܂B݂ȂOw肵ꍇ
	 * nullԂ܂B<br>
	 */
	public List<XMLElement> getElement(String name) {
		return content.get(name);
	}
	
	/**
	 * q̗vf݂邩܂.
	 * @param name vf̖O.<br>
	 * @return ݂ꍇtrueԂ܂.<br>
	 */
	public boolean hasElement(String name){
		return content.containsKey(name);
	}

	/**
	 * ̗vfXg[ɏo͂܂.
	 * ̃\bh̓fobOpłB<br>
	 * @param stream o͂Xg[𑗐M܂B<br>
	 */
	public void printAll(PrintStream stream) {
		stream.println(name + " " + attributes);
		for (List<XMLElement> elements : content.values()) {
			for (XMLElement element : elements) {
				stream.println(element);
			}
		}
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public String toString() {
		return "XMLElement{" + name + " : " + attributes + " : " + value + '}';
	}
}
