/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.resource.text;

import java.io.Serializable;
import kinugasa.resource.Nameable;

/**
 * XMLɂ""\NXł.
 * <br>
 * ͗vf0ȏݒłL[ƒl̃yAłB<br>
 * Ƃ΁A&lt;hoge fuga=piyo&gt;ł́A
 * fugaƂOpiyoƂl̑\z܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/03/15_7:10:56.<br>
 * @author dra0211 ( <a href="mailto:d0211@live.jp">d0211@live.jp</a>&nbsp;).<br>
 * <br>
 */
public class XMLAttribute implements Nameable, Serializable {

	private static final long serialVersionUID = -2192715007477514049L;
	/** ̖̑Oł. */
	private String name;
	/** ̑̒lł. */
	private String value;

	/**
	 * Oƒl󕶎̐V쐬܂.
	 */
	public XMLAttribute() {
		name = value = "";
	}

	/**
	 * Oƒlw肵āAV쐬܂.
	 * @param name
	 * @param value
	 */
	public XMLAttribute(String name, String value) {
		this.name = name;
		this.value = value;
	}

	@Override
	public String getName() {
		return name;
	}

	/**
	 * l𐮐ƂĎ擾܂.
	 * @return lInteger.parseIntgpĐɕϊĕԂ܂B<br>
	 * @throws NumberFormatException lϊłȂꍇɓ܂B<br>
	 */
	public int getIntValue() throws NumberFormatException {
		return Integer.parseInt(value);
	}

	/**
	 * lł邩܂.
	 * @return getIntValuegpłꍇtrueԂ܂B<br>
	 */
	public boolean isIntValue() {
		try {
			getIntValue();
			return true;
		} catch (NumberFormatException ex) {
			return false;
		}
	}

	/**
	 * lƂĎ擾܂.
	 * @return lFloat.parseFloatgpĎɕϊĕԂ܂B<br>
	 * @throws NumberFormatException lϊłȂꍇɓ܂B<br>
	 */
	public float getFloatValue() throws NumberFormatException {
		return Float.parseFloat(value);
	}

	/**
	 * lfloatł邩܂.
	 * @return getFloatValuegpłꍇtrueԂ܂B<br>
	 */
	public boolean isFloatValue() {
		try {
			getFloatValue();
			return true;
		} catch (NumberFormatException ex) {
			return false;
		}
	}

	/**
	 * l_lƂĎ擾܂.
	 * @return lBoolean.parseBooleangpĘ_lɕϊĕԂ܂B<br>
	 */
	public boolean getBool() {
		return Boolean.parseBoolean(value);
	}

	/**
	 * ̖̑OύX܂.
	 * ÓAXMLAttriobuteStorageQƂ邽߁A
	 * dȂꍇ܂B<br>
	 * @param name VOw肵܂B<br>
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * ̑̒lύX܂.
	 * @param value Vlw肵܂B<br>
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * ̑̒l擾܂.
	 * @return lԂ܂B<br>
	 */
	public String getValue() {
		return value;
	}

	@Override
	public String toString() {
		return name + "=" + value;
	}
}
