package kinugasa.resource.sound;

import static kinugasa.game.input.GamePadConnection.free;
import kinugasa.resource.DynamicStorage;
import kinugasa.resource.Input;
import kinugasa.resource.InputStatus;
import kinugasa.resource.Nameable;
import kinugasa.resource.text.FileIOException;



/**
 * TEḧꎞIȕۑ̈񋟂܂.
 * <br>
 * ̃Xg[W̎̓WbÑvZbgɂāA
 * ʉBGMĐ邽߂̃L[w肳Ăꍇ܂B<br>
 *
 * 쐬ꂽTEh}bv͎IɃTEhXg[Wɒǉ܂B<br>
 * TEh}bv̖Ow肵Ȃꍇ́AKȖO蓖Ă܂B<br>
 * <br>
 * TEh̋ۃNX̌^ɒӂĂB1̃}bvɊ܂܂ATEȟ^
 * ꂷ邱Ƃ𐄏܂B<br>
 * <br>
 * Freeable̎́A}bvɒǉĂ邷ׂẴTEhɍs܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/02/06_7:52:47<br>
 * @author Dra0211<br>
 */
public final class SoundMap extends DynamicStorage<Sound> implements Nameable {

	/** ̃TEh}bv̖Oł.
	 * Ƃ΁AuAvu_W5v̂悤Ȃ킩₷Ot邱Ƃł܂B */
	private String name;
	/** TEh}bṽCX^X̃JE^ł. */
	private static int counter;

	/**
	 * KȖOw肵ĐVTEh}bv쐬܂.
	 */
	public SoundMap() {
		this("SoundMap_" + (counter++));
	}

	/**
	 * OƏf[^w肵āATEh}bv쐬܂.
	 *
	 * @param name TEh}bv̖Ow肵܂B<br>
	 * @param sounds f[^w肵܂B<br>
	 */
	public SoundMap(String name, Sound... sounds) {
		this(name);
		super.addAll(sounds);
	}

	/**
	 * Ow肵ăTEh}bv쐬܂.
	 *
	 * @param name TEh}bv̖Ow肵܂B<br>
	 */
	public SoundMap(String name) {
		this.name = name;
		setStorage();
	}

	/**
	 * TEhXg[WthisCX^Xǉ܂.
	 */
	private void setStorage() {
		SoundStorage.getInstance().add(this);
	}

	/**
	 * TEhr_ALbVTEh쐬Ã}bvɒǉ܂.
	 *
	 * @param soundBuilder 쐬TEh̐ݒsr_łB<br>
	 *
	 * @return 쐬ꂽTEhԂ܂B̃}bvɒǉĂ܂B<br>
	 */
	public CachedSound createCachedSound(SoundBuilder soundBuilder) {
		CachedSound sound = soundBuilder.builde();
		add(sound);
		return sound;
	}

	@Override
	public String getName() {
		return name;
	}

	/**
	 * SẴTEhjATEhXg[W炱̃}bv폜܂.
	 */
	@Override
	public void dispose() {
		free();
		SoundStorage.getInstance().remove(this);
	}

	
	public void stopAll(){
		for (Sound sound : this) {
			sound.stop();
		}
	}

	@Override
	public SoundMap load() throws FileIOException {
		forEach(s->s.load());
		return this;
	}

	@Override
	public InputStatus getStatus() {
		for(Sound s : this ){
			if( s.getStatus() == InputStatus.LOADED)return InputStatus.LOADED;
		}
		return InputStatus.NOT_LOADED;
	}
}
