/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.object.movemodel;

import kinugasa.object.BasicSprite;
import kinugasa.object.MovingModel;

/**
 * .
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_18:38:13<br>
 * @author Dra0211<br>
 */
public class AngleChange extends MovingModel {

	/** ̈ړŉZl. */
	private float addDir;
	/** ŏ̊px. */
	private float startDir = Float.NaN;
	/** px̕ύX\Ȓl. */
	private float spread = Float.POSITIVE_INFINITY;
	/** ύXꂽpx̗݌v. */
	private float angSum = 0f;

	/**
	 * VCxg\z܂.
	 * ̃RXgN^ł́Aspread̖͐ɂȂ܂.āAɊpxύXCxg܂.<br>
	 * 
	 * @param add ړ̓xɒǉx@̊px̒l.wł.<br>
	 */
	public AngleChange(float add) {
		this.addDir = add;
	}

	/**
	 * VCxg\z܂.
	 * 
	 * @param add    ړ̓xɒǉx@̊px̒l.wł.<br>
	 * @param spread px̕ύX\Ȓl.݌v̕ύXꂽpx̍̒l𒴂ƁAȏύXsȂȂ.<br>
	 */
	public AngleChange(float add, float spread) {
		super();
		this.addDir = add;
		this.spread = spread;
	}

	/**
	 * ړ̓xɒǉl擾܂.
	 * 
	 * @return pxɒǉl.<bR>
	 */
	public float getAddDir() {
		return addDir;
	}

	/**
	 * ړ̓xɒǉlݒ肵܂.
	 * 
	 * @param addDir pxɒǉl.<bR>
	 */
	public void setAddDir(float addDir) {
		this.addDir = addDir;
	}

	/**
	 * ύX\Ȋpx̒l擾܂.
	 * 
	 * @return ύX\Ȋpx̏.<br>
	 */
	public float getSpread() {
		return spread;
	}

	/**
	 * ύX\Ȋpx̒lݒ肵܂.
	 * 
	 * @param spread ύX\Ȋpx̏.<br>
	 */
	public void setSpread(float spread) {
		this.spread = spread;
	}

	/**
	 * CxgΏۃIuWFNg̍ŏɐݒ肳Ăpx擾܂.
	 * 
	 * @return CxgΏۃIuWFNgɍŏɐݒ肳Ăpx̓x@\L.<br>
	 */
	public float getStartDir() {
		return startDir;
	}

	@Override
	public void move(BasicSprite s) {
		if (startDir == Float.NaN) {
			startDir = s.getVector().getAngle();
		}
		if (angSum < spread) {
			s.getVector().addAngle(addDir);
			angSum += Math.abs(addDir);
		}
		s.setX(s.getX() + s.getVector().getX());
		s.setY(s.getY() + s.getVector().getY());
	}

	@Override
	public AngleChange clone() {
		return (AngleChange) super.clone();
	}
}
