/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.graphics;

/**
 * FvftF[hC^tF[hAEg邽߂ColorCounter̎ł.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/12_19:07:48<br>
 * @author Dra0211<br>
 */
public class FadeCounter extends ColorTransitionModel {

	private static final long serialVersionUID = -1609450992263652227L;
	/** tF[h̑xłBJE^̌ݒlɑ܂. */
	private int speed;

	/**
	 * lƑJڑxw肵āAtF[hJE^쐬܂.
	 * @param value JE^̏lłB0255̊ԂŎw肵܂B<br>
	 * @param speed JE^̑JڑxłBwł܂B<br>
	 * @throws IllegalArgumentException l0A255𒴂ꍇɓ܂B<br>
	 */
	public FadeCounter(int value, int speed) throws IllegalArgumentException {
		super(value);
		this.speed = speed;
	}

	/**
	 * 0JnJE^쐬܂.
	 * @param speed JE^̑Jڑxw肵܂B
	 * ̃\bhł́Aʏ͐w肵܂B<br>
	 * @return tF[hCp̃JE^쐬܂B<br>
	 */
	public static FadeCounter fadeIn(int speed) {
		return new FadeCounter(MIN, speed);
	}

	/**
	 * 255JnJE^쐬܂.
	 * @param speed JE^̑Jڑxw肵܂B
	 * ̃\bhł́Aʏ͕w肵܂B<br>
	 * @return tF[hAEgp̃JE^쐬܂B<br>
	 */
	public static FadeCounter fadeOut(int speed) {
		return new FadeCounter(MAX, speed);
	}

	@Override
	public void update() {
		if (ended) {
			return;
		}
		started = true;
		value += speed;
		if (value < MIN) {
			value = MIN;
			ended = true;
		} else if (value > MAX) {
			value = MAX;
			ended = true;
		}
	}
	/** uJnĂvԃtOł.
	 * ŏupdateĂяoƁAtrueɂȂ܂B
	 * ȍ~́AtrueԂ܂B */
	private boolean started = false;
	/** uIĂvԃtOł.
	 * JE^̒lL͈͂o
	 * trueɂȂ܂Bȍ~͏trueԂ܂B */
	private boolean ended = false;

	/**
	 * {@inheritDoc }
	 * <br>
	 * ̎ł͍ŏupdateĂяoƁAȍ~͏ɁuJnĂԁvƂȂ܂B<br>
	 */
	@Override
	public boolean isRunning() {
		return started;
	}

	/**
	 * {@inheritDoc }
	 * <br>
	 * ̎ł́Aupdate\bhɂăJE^̒lL͈͂o
	 * ȍ~͏ɁuIĂԁvƂȂ܂B<br>
	 */
	@Override
	public boolean isEnded() {
		return ended;
	}

	@Override
	public String toString() {
		return "ColorFadeCounter{" + "value=" + value + ", " + "speed=" + speed + '}';
	}

	@Override
	public FadeCounter clone() {
		return (FadeCounter) super.clone();
	}
}
