/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game.input;

/**
 * L[{[h̃L[w肷邽߂̗񋓂ł.
 * <br>
 * Keys͑ΉL[AWTL[R[h܂B AWTL[R[hɂẮAjava.awt.event.KeyEventNX̃t@XQƂĂB<br>
 * <br>
 *
 * @see java.awt.event.KeyEvent
 *
 * @version 1.0.0 - 2013/01/14_13:04:22<br>
 * @version 1.1.0 - 2015/06/19_22:49<br>
 * @author Dra0211<br>
 */
public enum Keys {

	/**
	 * L[̏ł.
	 */
	UP(java.awt.event.KeyEvent.VK_UP),
	/**
	 * L[̉ł.
	 */
	DOWN(java.awt.event.KeyEvent.VK_DOWN),
	/**
	 * L[̍ł.
	 */
	LEFT(java.awt.event.KeyEvent.VK_LEFT),
	/**
	 * L[̉Eł.
	 */
	RIGHT(java.awt.event.KeyEvent.VK_RIGHT),
	/**
	 * WL[Ɠł.
	 */
	WASD_UP(java.awt.event.KeyEvent.VK_W),
	/**
	 * SL[Ɠł.
	 */
	WASD_DOWN(java.awt.event.KeyEvent.VK_S),
	/**
	 * AL[Ɠł.
	 */
	WASD_LEFT(java.awt.event.KeyEvent.VK_A),
	/**
	 * DL[Ɠł.
	 */
	WASD_RIGHT(java.awt.event.KeyEvent.VK_D),
	/**
	 * NUMPAD8Ɠł.
	 */
	PAD_UP(java.awt.event.KeyEvent.VK_NUMPAD8),
	/**
	 * NUMPAD2Ɠł.
	 */
	PAD_DOWN(java.awt.event.KeyEvent.VK_NUMPAD2),
	/**
	 * NUMPAD4Ɠł.
	 */
	PAD_LEFT(java.awt.event.KeyEvent.VK_NUMPAD4),
	/**
	 * NUMPAD6Ɠł.
	 */
	PAD_RIGHT(java.awt.event.KeyEvent.VK_NUMPAD6),
	/**
	 * NUMPAD7Ɠł.
	 */
	PAD_LEFTUP(java.awt.event.KeyEvent.VK_NUMPAD7),
	/**
	 * NUMPAD9Ɠł.
	 */
	PAD_RIGHTUP(java.awt.event.KeyEvent.VK_NUMPAD9),
	/**
	 * NUMPAD1Ɠł.
	 */
	PAD_LEFTDOWN(java.awt.event.KeyEvent.VK_NUMPAD1),
	/**
	 * NUMPAD3Ɠł.
	 */
	PAD_RIGHTDOWN(java.awt.event.KeyEvent.VK_NUMPAD3),
	/**
	 * NUMPAD5Ɠł.
	 */
	PAD_CENTER(java.awt.event.KeyEvent.VK_NUMPAD5),
	/**
	 * Xy[XL[ł.
	 */
	SPACE(java.awt.event.KeyEvent.VK_SPACE),
	/**
	 * CTRLL[ł.
	 */
	CTRL(java.awt.event.KeyEvent.VK_CONTROL),
	/**
	 * VtgL[ł.
	 */
	SHIFT(java.awt.event.KeyEvent.VK_SHIFT),
	/**
	 * G^[L[ł.
	 */
	ENTER(java.awt.event.KeyEvent.VK_ENTER),
	/**
	 * GXP[vL[ł.
	 */
	ESCAPE(java.awt.event.KeyEvent.VK_ESCAPE),
	/**
	 * obNXy[XL[ł.
	 */
	BACK_SPACE(java.awt.event.KeyEvent.VK_BACK_SPACE),
	/**
	 * ΉL[\܂.
	 */
	A(java.awt.event.KeyEvent.VK_A),
	/**
	 * ΉL[\܂.
	 */
	B(java.awt.event.KeyEvent.VK_B),
	/**
	 * ΉL[\܂.
	 */
	C(java.awt.event.KeyEvent.VK_C),
	/**
	 * ΉL[\܂.
	 */
	D(java.awt.event.KeyEvent.VK_D),
	/**
	 * ΉL[\܂.
	 */
	E(java.awt.event.KeyEvent.VK_E),
	/**
	 * ΉL[\܂.
	 */
	F(java.awt.event.KeyEvent.VK_F),
	/**
	 * ΉL[\܂.
	 */
	G(java.awt.event.KeyEvent.VK_G),
	/**
	 * ΉL[\܂.
	 */
	H(java.awt.event.KeyEvent.VK_H),
	/**
	 * ΉL[\܂.
	 */
	I(java.awt.event.KeyEvent.VK_I),
	/**
	 * ΉL[\܂.
	 */
	J(java.awt.event.KeyEvent.VK_J),
	/**
	 * ΉL[\܂.
	 */
	K(java.awt.event.KeyEvent.VK_K),
	/**
	 * ΉL[\܂.
	 */
	L(java.awt.event.KeyEvent.VK_L),
	/**
	 * ΉL[\܂.
	 */
	M(java.awt.event.KeyEvent.VK_M),
	/**
	 * ΉL[\܂.
	 */
	N(java.awt.event.KeyEvent.VK_N),
	/**
	 * ΉL[\܂.
	 */
	O(java.awt.event.KeyEvent.VK_O),
	/**
	 * ΉL[\܂.
	 */
	P(java.awt.event.KeyEvent.VK_P),
	/**
	 * ΉL[\܂.
	 */
	Q(java.awt.event.KeyEvent.VK_Q),
	/**
	 * ΉL[\܂.
	 */
	R(java.awt.event.KeyEvent.VK_R),
	/**
	 * ΉL[\܂.
	 */
	S(java.awt.event.KeyEvent.VK_S),
	/**
	 * ΉL[\܂.
	 */
	T(java.awt.event.KeyEvent.VK_T),
	/**
	 * ΉL[\܂.
	 */
	U(java.awt.event.KeyEvent.VK_U),
	/**
	 * ΉL[\܂.
	 */
	V(java.awt.event.KeyEvent.VK_V),
	/**
	 * ΉL[\܂.
	 */
	W(java.awt.event.KeyEvent.VK_W),
	/**
	 * ΉL[\܂.
	 */
	X(java.awt.event.KeyEvent.VK_X),
	/**
	 * ΉL[\܂.
	 */
	Y(java.awt.event.KeyEvent.VK_Y),
	/**
	 * ΉL[\܂.
	 */
	Z(java.awt.event.KeyEvent.VK_Z),
	/**
	 * NUM_PAD̐L[ł.
	 */
	PAD_1(java.awt.event.KeyEvent.VK_NUMPAD1),
	/**
	 * NUM_PAD̐L[ł.
	 */
	PAD_2(java.awt.event.KeyEvent.VK_NUMPAD2),
	/**
	 * NUM_PAD̐L[ł.
	 */
	PAD_3(java.awt.event.KeyEvent.VK_NUMPAD3),
	/**
	 * NUM_PAD̐L[ł.
	 */
	PAD_4(java.awt.event.KeyEvent.VK_NUMPAD4),
	/**
	 * NUM_PAD̐L[ł.
	 */
	PAD_5(java.awt.event.KeyEvent.VK_NUMPAD6),
	/**
	 * NUM_PAD̐L[ł.
	 */
	PAD_6(java.awt.event.KeyEvent.VK_NUMPAD6),
	/**
	 * NUM_PAD̐L[ł.
	 */
	PAD_7(java.awt.event.KeyEvent.VK_NUMPAD7),
	/**
	 * NUM_PAD̐L[ł.
	 */
	PAD_8(java.awt.event.KeyEvent.VK_NUMPAD8),
	/**
	 * NUM_PAD̐L[ł.
	 */
	PAD_9(java.awt.event.KeyEvent.VK_NUMPAD9),
	/**
	 * NUM_PAD̐L[ł.
	 */
	PAD_0(java.awt.event.KeyEvent.VK_NUMPAD0),
	/**
	 * NUM_PADłȂio[L[ł.
	 */
	NUM_1(java.awt.event.KeyEvent.VK_1),
	/**
	 * NUM_PADłȂio[L[ł.
	 */
	NUM_2(java.awt.event.KeyEvent.VK_2),
	/**
	 * NUM_PADłȂio[L[ł.
	 */
	NUM_3(java.awt.event.KeyEvent.VK_3),
	/**
	 * NUM_PADłȂio[L[ł.
	 */
	NUM_4(java.awt.event.KeyEvent.VK_4),
	/**
	 * NUM_PADłȂio[L[ł.
	 */
	NUM_5(java.awt.event.KeyEvent.VK_5),
	/**
	 * NUM_PADłȂio[L[ł.
	 */
	NUM_6(java.awt.event.KeyEvent.VK_6),
	/**
	 * NUM_PADłȂio[L[ł.
	 */
	NUM_7(java.awt.event.KeyEvent.VK_7),
	/**
	 * NUM_PADłȂio[L[ł.
	 */
	NUM_8(java.awt.event.KeyEvent.VK_8),
	/**
	 * NUM_PADłȂio[L[ł.
	 */
	NUM_9(java.awt.event.KeyEvent.VK_9),
	/**
	 * NUM_PADłȂio[L[ł.
	 */
	NUM_0(java.awt.event.KeyEvent.VK_0),
	/**
	 * ̃L[̓t@NVL[`܂.
	 */
	F1(java.awt.event.KeyEvent.VK_F1),
	/**
	 * ̃L[̓t@NVL[`܂.
	 */
	F2(java.awt.event.KeyEvent.VK_F2),
	/**
	 * ̃L[̓t@NVL[`܂.
	 */
	F3(java.awt.event.KeyEvent.VK_F3),
	/**
	 * ̃L[̓t@NVL[`܂.
	 */
	F4(java.awt.event.KeyEvent.VK_F4),
	/**
	 * ̃L[̓t@NVL[`܂.
	 */
	F5(java.awt.event.KeyEvent.VK_F5),
	/**
	 * ̃L[̓t@NVL[`܂.
	 */
	F6(java.awt.event.KeyEvent.VK_F6),
	/**
	 * ̃L[̓t@NVL[`܂.
	 */
	F7(java.awt.event.KeyEvent.VK_F7),
	/**
	 * ̃L[̓t@NVL[`܂.
	 */
	F8(java.awt.event.KeyEvent.VK_F8),
	/**
	 * ̃L[̓t@NVL[`܂.
	 */
	F9(java.awt.event.KeyEvent.VK_F9),
	/**
	 * ̃L[̓t@NVL[`܂.
	 */
	F10(java.awt.event.KeyEvent.VK_F10),
	/**
	 * ̃L[̓t@NVL[`܂.
	 */
	F11(java.awt.event.KeyEvent.VK_F11),
	/**
	 * ̃L[̓t@NVL[`܂.
	 */
	F12(java.awt.event.KeyEvent.VK_F12),
	/**
	 * INSERTL[ł.
	 */
	INSERT(java.awt.event.KeyEvent.VK_INSERT),
	/**
	 * DELETEL[ł.
	 */
	DELETE(java.awt.event.KeyEvent.VK_DELETE),
	/**
	 * HOMEL[ł.
	 */
	HOME(java.awt.event.KeyEvent.VK_HOME),
	/**
	 * ENDL[ł.
	 */
	END(java.awt.event.KeyEvent.VK_END),
	/**
	 * PAGEUPL[ł.
	 */
	PAGE_UP(java.awt.event.KeyEvent.VK_PAGE_UP),
	/**
	 * PAGEDOWNL[ł.
	 */
	PAGE_DOWN(java.awt.event.KeyEvent.VK_PAGE_DOWN),;
	/**
	 * L[AWTL[ԍ.
	 */
	private final int keyCode;

	/**
	 * AWT̃o[`L[ԍ擾܂.
	 *
	 * @return ΉAWTL[R[hԂ܂.<br>
	 */
	public int getKeyCode() {
		return keyCode;
	}

	private Keys(int keyCode) {
		this.keyCode = keyCode;
	}
}
