/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game.input;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.BitSet;

/**
 * L[{[h̓͏Ԃ邽߂KeListener̎ł.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_14:49:55<br>
 * @author Dra0211<br>
 */
public class KeyConnection implements KeyListener {

	/** L[Ԃi[rbgZbgł. */
	private static final BitSet keySet = new BitSet(512);
	/** B̃CX^Xł. */
	private static final KeyConnection INSTANCE = new KeyConnection();
	/** ͂ĂȂԂKeyStateł. */
	private static final KeyState CLEAR_STATE = new KeyState(new BitSet(512));

	/**
	 * VOgNXł.CX^Xł܂.<br>
	 */
	private KeyConnection() {
	}

	/**
	 * R|[lgɂ̃Xiǉ܂.
	 *
	 * @param component Xio^R|[lg𑗐M܂B<br>
	 */
	public static void setListener(Component component) {
		component.addKeyListener(INSTANCE);
	}

	/**
	 * ̃L[Xe[g𔭍s܂.
	 * ̃\bh͏ɓCX^XԂ܂B<br>
	 *
	 * @return ̃L[Xe[gԂ܂BĂȂԂłB<br>
	 */
	public static KeyState createClearState() {
		return CLEAR_STATE;
	}

	/**
	 * ݂̓͏Ԃ擾܂.
	 *
	 * @return ݂̃L[͏ԂłB<br>
	 */
	public static KeyState getState() {
		return new KeyState(KeyConnection.keySet);
	}

	/**
	 * L[Xi̎ł.
	 *
	 * @param ke L[CxgM܂B<br>
	 */
	@Override
	public void keyTyped(KeyEvent ke) {
	}

	/**
	 * L[Xi̎ł.
	 *
	 * @param ke L[CxgM܂B<br>
	 */
	@Override
	public void keyPressed(KeyEvent ke) {
		keySet.set(ke.getKeyCode());
	}

	/**
	 * L[Xi̎ł.
	 *
	 * @param ke L[CxgM܂B<br>
	 */
	@Override
	public void keyReleased(KeyEvent ke) {
		keySet.clear(ke.getKeyCode());
	}
}
