/*
 * The MIT License
 *
 * Copyright 2021 Dra.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game.input;

import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.ImageIcon;
import kinugasa.game.GraphicsContext;
import kinugasa.game.ui.FontModel;
import kinugasa.game.ui.SimpleTextLabelModel;
import kinugasa.game.ui.TextLabelModel;
import kinugasa.game.ui.TextLabelSprite;
import kinugasa.object.BasicSprite;

/**
 * Q[pbh̏Ԃ\XvCgłB
 * @vesion 1.0.0 - 2021/11/23_8:44:45<br>
 * @author Dra211<br>
 */
public class GamePadStatusMonitor extends BasicSprite {

	private ImageIcon image = new ImageIcon(getClass().getResource("gamepad.png"));

	public GamePadStatusMonitor() {

	}

	private GamePadState gs;

	public void update(GamePadState gs) {
		this.gs = gs;
		A.setExist(gs.buttons.A);
		B.setExist(gs.buttons.B);
		X.setExist(gs.buttons.X);
		Y.setExist(gs.buttons.Y);
		
		RB.setExist(gs.buttons.RB);
		LB.setExist(gs.buttons.LB);
		
		RS.setExist(gs.buttons.RIGHT_STICK);
		LS.setExist(gs.buttons.LEFT_STICK);
		
		L.setExist(gs.buttons.POV_LEFT);
		R.setExist(gs.buttons.POV_RIGHT);
		U.setExist(gs.buttons.POV_UP);
		D.setExist(gs.buttons.POV_DOWN);
		
		BACK.setExist(gs.buttons.BACK);
		START.setExist(gs.buttons.START);
		
		LT.setWidth(gs.triggeres.LEFT.value*100);
		RT.setWidth(gs.triggeres.RIGHT.value*100);
		
		LST.setX(164+gs.sticks.LEFT.x*33);
		LST.setY(160+gs.sticks.LEFT.y*33);
		
		RST.setX(380+gs.sticks.RIGHT.x*33);
		RST.setY(260+gs.sticks.RIGHT.y*33);
		
	}
	private ButtonSprite A = new ButtonSprite("A", 464, 210,20);
	private ButtonSprite B = new ButtonSprite("B", 484, 180,20);
	private ButtonSprite X = new ButtonSprite("X", 444, 180,20);
	private ButtonSprite Y = new ButtonSprite("Y", 464, 150,20);
	
	private ButtonSprite RB = new ButtonSprite("RB", 464, 110,36);
	private ButtonSprite LB = new ButtonSprite("LB", 124, 110,36);

	private ButtonSprite RS = new ButtonSprite("RS", 164, 160,36);
	private ButtonSprite LS = new ButtonSprite("LS", 380, 260,36);

	private ButtonSprite L = new ButtonSprite("<", 194, 270,20);
	private ButtonSprite R = new ButtonSprite(">", 244, 270,20);
	private ButtonSprite U = new ButtonSprite("^", 218, 250,20);
	private ButtonSprite D = new ButtonSprite("v", 218, 290,20);
	
	private ButtonSprite BACK = new ButtonSprite("Ba", 238, 160,36);
	private ButtonSprite START = new ButtonSprite("St", 368, 160,36);
	
	private TrrigerSprite LT = new TrrigerSprite("LT",85, 75);
	private TrrigerSprite RT = new TrrigerSprite("RT",430, 75);
	
	private StickSprite LST = new StickSprite("L",164, 160, 20);
	private StickSprite RST = new StickSprite("R",380, 260, 20);
	
	
	@Override
	public void draw(GraphicsContext g) {
		g.drawImage(image.getImage(), 0, 0);

		A.draw(g);
		B.draw(g);
		X.draw(g);
		Y.draw(g);
		RB.draw(g);
		LB.draw(g);
		
		RS.draw(g);
		LS.draw(g);
		
		R.draw(g);
		L.draw(g);
		U.draw(g);
		D.draw(g);
		
		BACK.draw(g);
		START.draw(g);
		
		LT.draw(g);
		RT.draw(g);
		
		LST.draw(g);
		RST.draw(g);
		
		
	}

}

class ButtonSprite extends TextLabelSprite {

	private static final TextLabelModel MODEL = new SimpleTextLabelModel("DEFAULT", FontModel.DEFAULT);

	public ButtonSprite(String msg, float x, float y, int w) {
		super(msg, MODEL, x, y, w, 18);
	}

	@Override
	public void draw(GraphicsContext g) {
		Graphics2D g2 = g.create();
		g2.setColor(Color.BLACK);
		if (super.isExist()) {
			g2.fillRect((int) getX()-4, (int) getY(), (int) getWidth(), (int) getHeight()+4);
		} else {
			g2.drawRect((int) getX()-4, (int) getY(), (int) getWidth(), (int) getHeight()+4);
		}
		super.draw(g); //To change body of generated methods, choose Tools | Templates.
		g2.dispose();
	}

}

class TrrigerSprite extends TextLabelSprite{

	private static final TextLabelModel MODEL = new SimpleTextLabelModel("DEFAULT", FontModel.DEFAULT);

	public TrrigerSprite(String msg, float x, float y) {
		super(msg, MODEL, x, y, 0, 18);
	}

	@Override
	public void draw(GraphicsContext g) {
		Graphics2D g2 = g.create();
		g2.setColor(Color.BLACK);
		g2.drawRect((int) getX()-4, (int) getY(), 100, (int) getHeight()+4);
		if (super.isExist()) {
			g2.fillRect((int) getX()-4, (int) getY(), (int) getWidth(), (int) getHeight()+4);
		} else {
			g2.drawRect((int) getX()-4, (int) getY(), (int) getWidth(), (int) getHeight()+4);
		}
		super.draw(g); //To change body of generated methods, choose Tools | Templates.
		g2.dispose();
	}

}


class StickSprite extends TextLabelSprite {

	private static final TextLabelModel MODEL = new SimpleTextLabelModel("DEFAULT", FontModel.DEFAULT);

	public StickSprite(String msg, float x, float y, int w) {
		super(msg, MODEL, x, y, w, 18);
	}

	@Override
	public void draw(GraphicsContext g) {
		Graphics2D g2 = g.create();
		g2.setColor(Color.BLACK);
		if (super.isExist()) {
			g2.fillRect((int) getX()-4, (int) getY(), (int) getWidth(), (int) getHeight()+4);
		} else {
			g2.drawRect((int) getX()-4, (int) getY(), (int) getWidth(), (int) getHeight()+4);
		}
		super.draw(g); //To change body of generated methods, choose Tools | Templates.
		g2.dispose();
	}

}