/*
 * The MIT License
 *
 * Copyright 2014 Dra.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game.input;

/**
 * .
 * <br>
 *
 * @version 1.0.0 - 2014/09/20<br>
 * @author Dra<br>
 * <br>
 */
public final class GamePadConnection{

	private GamePadConnection() {
	}

	public static void init() throws RuntimeException {
		if(load)throw new RuntimeException("dll is already loaded.");
		try {
			System.loadLibrary("KGP");
		} catch (Throwable t) {
			throw new RuntimeException(t);
		}
		load= true;
	}
	private static boolean load = false;

	public static native float[] getNativeState(int playerIndex);

	public static native void free();

	public static final int LENGTH = 21;
	/**
	 * ̒l̓Q[pbh̃fW^{^ʂ܂.
	 */
	public static final int BUTTON_A = 0;
	/**
	 * ̒l̓Q[pbh̃fW^{^ʂ܂.
	 */
	public static final int BUTTON_B = 1;
	/**
	 * ̒l̓Q[pbh̃fW^{^ʂ܂.
	 */
	public static final int BUTTON_X = 2;
	/**
	 * ̒l̓Q[pbh̃fW^{^ʂ܂.
	 */
	public static final int BUTTON_Y = 3;
	/**
	 * ̒l̓Q[pbh̃fW^{^ʂ܂.
	 */
	public static final int BUTTON_LB = 4;
	/**
	 * ̒l̓Q[pbh̃fW^{^ʂ܂.
	 */
	public static final int BUTTON_RB = 5;
	/**
	 * ̒l̓Q[pbh̃fW^{^ʂ܂.
	 */
	public static final int BUTTON_LEFT_STICK = 6;
	/**
	 * ̒l̓Q[pbh̃fW^{^ʂ܂.
	 */
	public static final int BUTTON_RIGHT_STICK = 7;
	/**
	 * ̒l̓Q[pbh̃fW^{^ʂ܂.
	 */
	public static final int BUTTON_POV_UP = 8;
	/**
	 * ̒l̓Q[pbh̃fW^{^ʂ܂.
	 */
	public static final int BUTTON_POV_DOWN = 9;
	/**
	 * ̒l̓Q[pbh̃fW^{^ʂ܂.
	 */
	public static final int BUTTON_POV_LEFT = 10;
	/**
	 * ̒l̓Q[pbh̃fW^{^ʂ܂.
	 */
	public static final int BUTTON_POV_RIGHT = 11;
	/**
	 * ̒l̓Q[pbh̃fW^{^ʂ܂.
	 */
	public static final int BUTTON_START = 12;
	/**
	 * ̒l̓Q[pbh̃fW^{^ʂ܂.
	 */
	public static final int BUTTON_BACK = 13;
	/**
	 * Q[pbh̃AiOgK[ʂ܂.
	 */
	public static final int TRIGGER_LEFT = 14;
	/**
	 * Q[pbh̃AiOgK[ʂ܂.
	 */
	public static final int TRIGGER_RIGHT = 15;
	/**
	 * Q[pbh̃AiOXeBbNʂ܂.
	 */
	public static final int THUMB_STICK_LEFT_X = 16;
	/**
	 * Q[pbh̃AiOXeBbNʂ܂.
	 */
	public static final int THUMB_STICK_LEFT_Y = 17;
	/**
	 * Q[pbh̃AiOXeBbNʂ܂.
	 */
	public static final int THUMB_STICK_RIGHT_X = 18;
	/**
	 * Q[pbh̃AiOXeBbNʂ܂.
	 */
	public static final int THUMB_STICK_RIGHT_Y = 19;
	/**
	 * Q[pbh̎ʏԂi[Ăꏊ̃CfbNXł.
	 */
	public static final int CONNECTION = 20;
	//
	/**
	 * dllɂĒ`AlCeBuȁuFALSEv̏Ԃł.
	 */
	public static final int NATIVE_FALSE = 0;
	/**
	 * dllɂĎgpAgK[̓͂̍ŏlł.
	 */
	public static final int TRIGGER_MIN = 0;
	/**
	 * dllɂĎgpAgK[̓͂̍őlł.
	 */
	public static final int TRIGGER_MAX = 255;
	/**
	 * dllɂĎgpAXeBbN̓͂̍ŏlł.
	 */
	public static final int THUMBSTICK_MIN = Short.MIN_VALUE;
	/**
	 * dllɂĎgpAgK[̓͂̃ftHglł.
	 */
	public static final int THUMBSTICK_CENTER = 0;
	/**
	 * dllɂĎgpAXeBbN̓͂̍őlł.
	 */
	public static final int THUMBSTICK_MAX = Short.MAX_VALUE;
	/**
	 * dllɂĎgpAgK[̓͂̍ŏl̍ől܂ł̐Βlł.
	 */
	public static final int THUMSTICK_ABS_MAX = 65534;
}
