/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game.event;

import java.io.Serializable;

/**
 * nŔCxg̏ƑΏۃIuWFNgi[NXł.
 * <br>
 * Cxg1́uIuWFNgvƁusv܂B<br>
 * ʏAs̓Q[̍XV񐔂Ɠ܂B̒l̓Cxg
 * EventManager̍XV񐔂Ƃɔ肵܂B<br>
 * IuWFNg̓Cxg̎sɂĕԂACełB<br>
 * IuWFNg͎sOɁio^Ɂj̃CX^X݂ĂȂ΂Ȃ܂B<br>
 * sɂ́AIuWFNgɑ΂ʂȑsA߂ƂŁA
 * Q[ŗpł悤ɂ܂B<br>
 * <br>
 * Cxgsł^C~ÓACxgɐݒ肳ꂽEntryModelɂĔf܂B<br>
 * <br>
 * <br>
 * Cxgł邩ǂID݂̂]܂B<br>
 *
 * @param <T> ̃CxgIuWFNǧ^w肵܂B<br>
 *
 * @version 1.0.0 - 2012/10/19_18:14:25.<br>
 * @author Dra0211<br>
 * <br>
 */
public abstract class TimeEvent<T> implements Comparable<TimeEvent<?>>, Serializable {

	/** Cxg̎ɂ̒lw肷ƁÃCxg͍ŏ̃^[Ŏs܂. */
	public static final long TIME_INITIAL = 0;
	/** Cxg̎ɂ̒lw肷ƁÃCxg͎s܂.
	 * ̒l-1LgpĂ̂ŁACxg̎-1Lgp邱Ƃ͂ł܂B */
	public static final long TIME_NOT_EXECUTE = -1L;
	/** Cxg̍ṽJE^ł. */
	private static int idCounter = 0;
	/** ̃CxgŗLIDł.
	 * ̒l͌ďdACxg쐬ꂽɘAԂ~܂B */
	private int id = ++idCounter;
	/** ̃Cxg̎sł. */
	private long executeTime;
	/** ̃Cxg̎sfł. */
	private EntryModel entryModel;
	/** ̃CxggpIuWFNgł.
	 * TuNXgpł܂B<br> */
	protected final T object;
	/** ̃Cxg^ł. */
	private Class<T> type;

	/**
	 * VCxg쐬܂.
	 * CxgIuWFNǵÃCxgԂŋʂ̃CX^Xgp邱Ƃł܂B<br>
	 * Cxg̋N-1(TIME_NOT_EXECUTE)w肵ꍇÃCxg͎słȂȂ邱ƂɒӂĂB<br>
	 * ŏɋNKv̂Cxg0w肵܂B<br>
	 *
	 * @param executeTime Cxg̋Nw肵܂B̒l͒ʏA}l[W̍XV񐔂ɂĔ肳܂B<br>
	 *                       Ƃ΁AFPS60ł́AJn炨悻1bɎ60ƂȂ܂B<br>
	 * @param entryModel  ̃Cxg̎s@\`܂B̃fgpāAutB[hɓGꍇ͏oȂv
	 *                       ̏𔻒肷邱Ƃł܂B<br>
	 * @param obj         CxggpIuWFNgw肵܂BIuWFNg͉\ȏꍇ́A[hɑM邱Ƃł܂B<br>
	 *
	 * @throws IllegalArgumentException NTIME_NOT_EXECUTE(-1)菬ꍇɓ܂B<br>
	 * @throws NullPointerException     gpIuWFNgnull̏ꍇɓ܂B<br>
	 */
	@SuppressWarnings("unchecked")
	public TimeEvent(long executeTime, EntryModel entryModel, T obj) throws IllegalArgumentException, NullPointerException {
		if (executeTime < TIME_NOT_EXECUTE) {
			throw new IllegalArgumentException("executeTime < NOT_EXECUTE :  id=[" + id + "], time=[" + executeTime + "]");
		}
		if (obj == null) {
			throw new NullPointerException("event obj == null id=" + id + "]");
		}
		this.executeTime = executeTime;
		this.entryModel = entryModel;
		this.object = obj;
		this.type = (Class<T>) obj.getClass();
	}

	/**
	 * ̃CxgID擾܂.
	 * ID̓Cxg̍쐬ɘAԂƂĊ蓖Ă܂B<br>
	 * ̃}l[W̃CxgłĂd邱Ƃ͂܂B<br>
	 *
	 * @return ̃CxgIDԂB<br>
	 */
	public final int getId() {
		return id;
	}

	/**
	 * 쐬ꂽCxg̍v擾܂.
	 *
	 * @return 쐬ς݂̃Cxg̐.<Br>
	 */
	public static int getEventsNum() {
		return idCounter;
	}

	/**
	 * ̃Cxg̃Ggfݒ肵܂.
	 *
	 * @param entryModel VGgfB<br>
	 */
	public final void setEntryModel(EntryModel entryModel) {
		this.entryModel = entryModel;
	}

	/**
	 * ̃Cxgɐݒ肳ĂGgf擾܂.
	 *
	 * @return GgfB<br>
	 */
	public final EntryModel getEntryModel() {
		return entryModel;
	}

	/**
	 * ̃Cxg_Ŏs\ł邩Ggfɂĕ]܂.
	 *
	 * @return ̃Cxg_ŎsłꍇtrueAłȂꍇfalseԂB<br>
	 */
	public final boolean isReaching() {
		return executeTime == TIME_NOT_EXECUTE ? false : entryModel.isReaching(this);
	}

	/**
	 * ̃Cxg̎s擾܂.
	 *
	 * @return ̃Cxg̎sB<br>
	 */
	public final long getExecuteTime() {
		return executeTime;
	}

	/**
	 * Cxg̏Ƀ\[g邽߂̔r@\ł.
	 * ̃\bh͕ʂ̌^̃CxgłĂrł܂B<br>
	 *
	 * @param o rCxgB<br>
	 *
	 * @return Compareble̎ɊÂlԂB<br>
	 */
	@Override
	public final int compareTo(TimeEvent<?> o) {
		return executeTime > o.executeTime ? 1 : executeTime < o.executeTime ? -1 : 0;
	}

	/**
	 * ̃CxgۗLĂIuWFNg擾܂.
	 *
	 * @return ̃CxgɂĎgpIuWFNgԂB<br>
	 */
	public final T getObject() {
		return object;
	}

	/**
	 * ̃Cxg^Ԃ܂.
	 *
	 * @return ̃Cxggp^B<br>
	 */
	public final Class<T> getType() {
		return type;
	}

	/**
	 * ̃Cxgs܂.
	 * sAԂύXꂽIuWFNg߂Kv܂B<br>
	 *
	 * @return ̃CxgɂďԂύXꂽIuWFNg߂B<br>
	 */
	public abstract T execute();

	@Override
	public String toString() {
		return "Event{" + "id=" + id + ", executeTime=" + executeTime + ", type=" + type + '}';
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		@SuppressWarnings("unchecked")
		final TimeEvent<T> other = (TimeEvent<T>) obj;
		if (this.id != other.id) {
			return false;
		}
		return true;
	}

	@Override
	public int hashCode() {
		int hash = 5;
		hash = 23 * hash + this.id;
		return hash;
	}
}