/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game.event;

import java.io.Serializable;
import kinugasa.game.GameLog;
import kinugasa.object.Statable;

/**
 * nCxgdg݂̊{Iȋ@\`܂.
 * <br>
 * ۂɔCxg[ EventNX ]̓}l[W̎ɂĈ^قȂ邽߁A
 * Cxgǉ@\͂̃NXɂ͒`Ă܂B<br>
 t[[Nł́A{IȎƂāATimeEventTMultiClassEventManagerƁA
 P̌^EventSIngleClassEventManagerpӂĂ܂B<br>
 * <br>
 * <br>
 * }l[WgpCxg̓Xg܂̓L[ƂĎ܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2012/11/15_8:10:37<br>
 * @author Dra0211<br>
 * <br>
 *
 */
public abstract class EventManager implements Statable, Serializable {

	private static final long serialVersionUID = -1656169201397066551L;
	/**
	 * }l[W̍XV񐔂łBCxg̔^C~ǑɎgp܂.
	 */
	private transient long progressTime = 0L;
	/**
	 * [hĂ邩ǂ̃tOł.
	 */
	private transient boolean load = false;
	/**
	 * ̃}l[W̎ƃCxg̎rłʓIȎł.
	 */
	protected final EntryModel TIME_BASE_ENTRY_MODEL = new EntryModel() {
		private static final long serialVersionUID = -3986406384609892814L;

		@Override
		public boolean isReaching(TimeEvent<?> evt) {
			return evt.getExecuteTime() > getProgressTime();
		}
	};

	/**
	 * }l[W\z܂. ʏ́ACxgi[郊XgL[܂B<br>
	 */
	public EventManager() {
	}

	/**
	 * Cxg}l[W̓ԂXV܂. ̃\bh͖^[i͉񂩂1jĂяoKv܂B<br>
	 * ̃\bhɂẴCxg}l[W̓XVA VCxgNł悤ɂȂ܂B<br>
	 */
	public void update() {
		progressTime++;
	}

	/**
	 * ̃Cxg}l[W̍XV񐔂擾܂. XV񐔂̓Cxg""\܂B<bR>
	 * ʏAXVACxg̎s傫ȂƂACxgN܂B<br>
	 * ̎͂̃JE^łAupdateĂяo񐔂ۊǂ܂B<br>
	 * t[XV邱ƂŁÃJE^͑t[Ɠ܂B<br>
	 *
	 * @return ̃Cxg}l[W̍XV񐔂Ԃ܂B<br>
	 */
	public long getProgressTime() {
		return progressTime;
	}

	public EventManager load() {
		init();
		sort();
		if (GameLog.isUsingLog()) {
			GameLog.printInfo("EventManager̃[hJn");
			printAll();
			GameLog.printInfo("EventManager̃[h");
		}
		load = true;
		return this;
	}

	/**
	 * }l[WɒǉĂCxg܂. ̃\bhload\bhR[ƎIɌĂ΂܂B<br>
	 * ۃNXł́Aadd\bhgpăCxgǉ鏈Lq Kv܂B<br>
	 */
	protected abstract void init();

	public EventManager free() {
		progressTime = 0L;
		clear();
		load = false;
		return this;
	}

	/**
	 * Xg[ɃCxg̏𔭍s܂. ̃\bh̓fobOpłBload\bhɂĎs܂B<br>
	 */
	public abstract void printAll();

	public boolean isLoaded() {
		return load;
	}

	/**
	 * }l[WɒǉĂCxgAnɉă\[g܂.
	 */
	public abstract void sort();

	/**
	 * }l[WɒǉĂA܂jĂȂCxg̐擾܂.
	 *
	 * @return ǉ݃Cxg̐Ԃ܂B<br>
	 */
	public abstract int size();

	/**
	 * }l[W̔jĂȂCxg̐0ł邩܂.
	 *
	 * @return }l[WɃCxgȂꍇtrueA1ȏ̃Cxgҋ@łꍇfalseԂ܂B<br>
	 */
	public abstract boolean isEmpty();

	/**
	 * }l[WɒǉĂ邷ׂẴCxgj܂.
	 */
	public abstract void clear();

	/**
	 * }l[WɃCxgevt܂܂Ă邩𒲂ׂ܂.
	 *
	 * @param evt Cxg𑗐M܂B<br>
	 *
	 * @return evtCxgXgɊ܂܂ĂꍇtrueԂ܂B<br>
	 */
	public abstract boolean contains(TimeEvent<?> evt);

	/**
	 * }l[WɃCxgevt܂܂Ă΍폜܂. ̃\bh͎sCxgj邽߂ɂgp܂B<br>
	 * evt܂܂ĂȂꍇ͉s܂B<br>
	 *
	 * @param evt 폜Cxg𑗐M܂B<br>
	 */
	public abstract void remove(TimeEvent<?> evt);

	/**
	 * }l[WɃCxgevt܂܂Ă΍폜܂. ̃\bh͎sCxgj邽߂ɂgp܂B<br>
	 * evt܂܂ĂȂꍇ͉s܂B<br>
	 *
	 * @param evt 폜Cxg𑗐M܂B<br>
	 */
	public abstract void removeAll(TimeEvent<?>... evt);

	@Override
	public String toString() {
		return "EventManager{" + "progressTime=" + progressTime + ", load=" + load + '}';
	}
}
