/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Q[̐issXbh̎ł.
 * <br>
 * ̃NXQ[쐬҂gp邱Ƃ͂܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_12:52:13<br>
 * @version 1.0.1 - 2013/04/27_21:11<br>
 * @author Dra0211<br>
 */
public final class GameLoop implements Runnable {

	/**
	 * ̃XbhXVΏۂ̃Q[.
	 */
	private GameManager game;
	/**
	 * FPSёҋ@Ԃ̊Ǘ.
	 */
	private GameTimeManager gtm;
	/**
	 * N郁C̃Xbh.
	 */
	private Thread thread;
	/**
	 * N.
	 */
	private volatile boolean exec = false;
	private boolean updateIfNotActive;

	/**
	 * VQ[pXbh쐬܂. 쐬ł́AN܂.<br>
	 *
	 * @param game Ώۂ̃Q[CX^X.<br>
	 * @param gtm FPSёҋ@ԂǗGameTimeManager.<br>
	 */
	GameLoop(GameManager game, GameTimeManager gtm) {
		this.game = game;
		this.gtm = gtm;
		this.updateIfNotActive = false;
	}

	/**
	 * VQ[pXbh쐬܂. 쐬ł́AN܂.<br>
	 *
	 * @param game Ώۂ̃Q[CX^X.<br>
	 * @param gtm FPSёҋ@ԂǗGameTimeManager.<br>
	 */
	GameLoop(GameManager game, GameTimeManager gtm, boolean updateIfNotActive) {
		this.game = game;
		this.gtm = gtm;
		this.updateIfNotActive = updateIfNotActive;
	}

	/**
	 * C[v̎ł.
	 */
	@Override
	public void run() {
		try {
			long startTime;
			if (updateIfNotActive) {
				while (exec) {
					startTime = System.nanoTime();
					game.update(gtm);
					game.repaint();
					gtm.sleep(startTime);
				}
			} else {
				while (exec) {
					if (game.getWindow().isActive()) {
						startTime = System.nanoTime();
						game.update(gtm);
						game.repaint();
						gtm.sleep(startTime);
					} else {
						startTime = System.nanoTime();
						try {//_~[
							Thread.sleep(1000 / gtm.getIdealFPS());
						} catch (InterruptedException ex) {
							Logger.getLogger(GameLoop.class.getName()).log(Level.SEVERE, null, ex);
						}
						gtm.sleep(startTime);
					}
				}
			}
		} catch (Throwable ex) {
			if (ex instanceof Exception) {
				((Exception) ex).printStackTrace();
			}
			GameLog.print(Level.WARNING, ex);
			System.exit(1);
		}
	}

	/**
	 * C[vI܂.
	 */
	void end() {
		exec = false;
	}

	/**
	 * XbhNAĕ`XVJn܂.
	 *
	 * @throws IllegalStateException łɋNĂꍇɓ.<br>
	 */
	void start() throws IllegalStateException {
		if (isStarted()) {
			throw new IllegalStateException("");
		}
		exec = true;
		thread = new Thread(this, game.getOption().getTitle() + ":1");
		thread.start();
	}

	/**
	 * XbhNĂ邩ǂ܂.
	 *
	 * @return startĂяoANĂꍇtrueԂ܂B<br>
	 */
	boolean isStarted() {
		return thread != null;
	}
}
