/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.resource.sound;

import kinugasa.game.input.GamePadConnection;
import kinugasa.resource.DynamicStorage;
import kinugasa.resource.InputStatus;
import kinugasa.resource.Nameable;
import kinugasa.resource.sound.CachedSound;
import kinugasa.resource.sound.Sound;
import kinugasa.resource.sound.SoundBuilder;
import kinugasa.resource.sound.SoundStorage;
import kinugasa.resource.text.FileIOException;

public final class SoundMap
extends DynamicStorage<Sound>
implements Nameable {
    private String name;
    private static int counter;

    public SoundMap() {
        this("SoundMap_" + counter++);
    }

    public SoundMap(String name, Sound ... sounds) {
        this(name);
        super.addAll((Nameable[])sounds);
    }

    public SoundMap(String name) {
        this.name = name;
        this.setStorage();
    }

    private void setStorage() {
        SoundStorage.getInstance().add(this);
    }

    public CachedSound createCachedSound(SoundBuilder soundBuilder) {
        CachedSound sound = soundBuilder.builde();
        this.add(sound);
        return sound;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void dispose() {
        GamePadConnection.free();
        SoundStorage.getInstance().remove(this);
    }

    public void stopAll() {
        for (Sound sound : this) {
            sound.stop();
        }
    }

    @Override
    public SoundMap load() throws FileIOException {
        this.forEach(s -> s.load());
        return this;
    }

    @Override
    public InputStatus getStatus() {
        for (Sound s : this) {
            if (s.getStatus() != InputStatus.LOADED) continue;
            return InputStatus.LOADED;
        }
        return InputStatus.NOT_LOADED;
    }
}

