/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.resource.sound;

import java.io.File;
import java.io.Serializable;
import kinugasa.resource.Nameable;
import kinugasa.resource.sound.CachedSound;
import kinugasa.resource.sound.LoopPoint;
import kinugasa.resource.sound.ReverbModel;
import kinugasa.resource.text.FileNotFoundException;

public final class SoundBuilder
implements Serializable,
Nameable {
    private File file;
    private LoopPoint loopPoint = LoopPoint.NO_USE;
    private ReverbModel reverbModel = ReverbModel.NO_USE;
    private float masterGain = 1.0f;
    private float volume = 1.0f;
    private float pan = 0.0f;
    private float sampleRate = 0.0f;
    private boolean newFile = false;
    private String name;

    public SoundBuilder(String filePath) throws FileNotFoundException {
        File soundFile = new File(filePath);
        if (!soundFile.exists()) {
            throw new FileNotFoundException("not found : filePath=[" + filePath + "]");
        }
        this.file = soundFile;
        this.name = this.file.getName();
    }

    public SoundBuilder setLoopPoint(LoopPoint loopPoint) {
        this.loopPoint = loopPoint;
        return this;
    }

    public SoundBuilder setLoopPoint(int from, int to) {
        this.loopPoint = new LoopPoint(from, to);
        return this;
    }

    public SoundBuilder setMasterGain(float masterGain) {
        this.masterGain = masterGain;
        return this;
    }

    public SoundBuilder setPan(float pan) {
        this.pan = pan;
        return this;
    }

    public SoundBuilder setVolume(float volume) {
        this.volume = volume;
        return this;
    }

    public SoundBuilder setReverbModel(ReverbModel reverbModel) {
        this.reverbModel = reverbModel;
        return this;
    }

    public SoundBuilder setSampleRate(float sampleRate) {
        this.sampleRate = sampleRate;
        return this;
    }

    public SoundBuilder newFile() {
        this.newFile = true;
        return this;
    }

    public SoundBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public LoopPoint getLoopPoint() {
        return this.loopPoint;
    }

    public float getMasterGain() {
        return this.masterGain;
    }

    public boolean isNewFile() {
        return this.newFile;
    }

    public float getPan() {
        return this.pan;
    }

    public ReverbModel getReverbModel() {
        return this.reverbModel;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public float getVolume() {
        return this.volume;
    }

    public CachedSound builde() {
        return CachedSound.create(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SoundBuilder other = (SoundBuilder)obj;
        if (!(this.file == other.file || this.file != null && this.file.equals(other.file))) {
            return false;
        }
        if (!(this.loopPoint == other.loopPoint || this.loopPoint != null && this.loopPoint.equals(other.loopPoint))) {
            return false;
        }
        if (!(this.reverbModel == other.reverbModel || this.reverbModel != null && this.reverbModel.equals(other.reverbModel))) {
            return false;
        }
        if (Float.floatToIntBits(this.masterGain) != Float.floatToIntBits(other.masterGain)) {
            return false;
        }
        if (Float.floatToIntBits(this.volume) != Float.floatToIntBits(other.volume)) {
            return false;
        }
        if (Float.floatToIntBits(this.pan) != Float.floatToIntBits(other.pan)) {
            return false;
        }
        if (Float.floatToIntBits(this.sampleRate) != Float.floatToIntBits(other.sampleRate)) {
            return false;
        }
        return this.newFile == other.newFile;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.file != null ? this.file.hashCode() : 0);
        hash = 97 * hash + (this.loopPoint != null ? this.loopPoint.hashCode() : 0);
        hash = 97 * hash + (this.reverbModel != null ? this.reverbModel.hashCode() : 0);
        hash = 97 * hash + Float.floatToIntBits(this.masterGain);
        hash = 97 * hash + Float.floatToIntBits(this.volume);
        hash = 97 * hash + Float.floatToIntBits(this.pan);
        hash = 97 * hash + Float.floatToIntBits(this.sampleRate);
        hash = 97 * hash + (this.newFile ? 1 : 0);
        return hash;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "SoundBuilder{file=" + this.file + ", loopPoint=" + this.loopPoint + ", reverbModel=" + this.reverbModel + ", masterGain=" + this.masterGain + ", volume=" + this.volume + ", pan=" + this.pan + ", sampleRate=" + this.sampleRate + ", newFile=" + this.newFile + "}";
    }
}

