/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.resource;

import kinugasa.game.GameLog;
import kinugasa.resource.ContentsIOException;
import kinugasa.resource.Storage;
import kinugasa.resource.TempFile;

public class TempFileStorage
extends Storage<TempFile> {
    private static final TempFileStorage INSTANCE = new TempFileStorage();
    private String prefix = "ktf_";
    private String suffix = ".tmp";

    private TempFileStorage() {
    }

    public static TempFileStorage getInstance() {
        return INSTANCE;
    }

    public TempFile create() throws ContentsIOException {
        TempFile file = new TempFile();
        this.add(file);
        return file;
    }

    public TempFile create(String prefix, String suffix) throws ContentsIOException {
        TempFile file = new TempFile(prefix, suffix);
        this.add(file);
        return file;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void deleteAll() {
        for (TempFile file : this) {
            if (!file.exists()) continue;
            file.delete();
        }
        GameLog.printInfoIfUsing("TempFileStorage : all temp file is deleted");
    }
}

