/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.resource;

import java.io.File;
import java.io.IOException;
import kinugasa.game.GameLog;
import kinugasa.resource.ContentsIOException;
import kinugasa.resource.Nameable;
import kinugasa.resource.TempFileStorage;

public final class TempFile
implements Nameable {
    private File file;

    protected TempFile() throws ContentsIOException {
        this(TempFileStorage.getInstance().getPrefix(), TempFileStorage.getInstance().getSuffix());
    }

    protected TempFile(String prefix, String suffix) throws ContentsIOException {
        try {
            this.file = File.createTempFile(prefix, suffix);
        }
        catch (IOException e) {
            throw new ContentsIOException(e);
        }
        GameLog.printInfoIfUsing("temp file " + this.file.getPath() + " is created");
    }

    public String getPath() {
        return this.file.getPath();
    }

    public File getFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void delete() {
        this.file.delete();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }
}

