/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.resource;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kinugasa.resource.DuplicateNameException;
import kinugasa.resource.NameNotFoundException;
import kinugasa.resource.Nameable;

public class Storage<T extends Nameable>
implements Iterable<T> {
    private HashMap<String, T> map;

    public Storage() {
        this.map = new HashMap(32);
    }

    public Storage(int initialSize) {
        this.map = new HashMap(initialSize);
    }

    public T get(String key) throws NameNotFoundException {
        if (!this.contains(key)) {
            throw new NameNotFoundException("! > Storage : get : not found : key=[" + key.toString() + "]");
        }
        return (T)((Nameable)this.map.get(key));
    }

    public T getIfContains(String key) {
        return (T)((Nameable)this.map.get(key));
    }

    public Collection<T> getAll() {
        return this.map.values();
    }

    public List<T> asList() {
        return new ArrayList<T>(this.getAll());
    }

    public boolean contains(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsAll(String ... keys) {
        for (String key : keys) {
            if (this.contains(key)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(T obj) {
        return this.contains(obj.getName());
    }

    public void add(T val) throws DuplicateNameException {
        if (this.contains(val.getName())) {
            throw new DuplicateNameException("! > Storage : add : duplicate name : name=[" + val.getName() + "]");
        }
        this.map.put(val.getName(), val);
    }

    public void addAll(T ... values) throws DuplicateNameException {
        this.addAll((Collection<? extends T>)Arrays.asList(values));
    }

    public void addAll(Collection<? extends T> values) throws DuplicateNameException {
        for (Nameable value : values) {
            this.add(value);
        }
    }

    public void put(T val) {
        this.map.put(val.getName(), val);
    }

    public void putAll(T ... values) {
        this.putAll((Collection<? extends T>)Arrays.asList(values));
    }

    public void putAll(Collection<? extends T> values) {
        for (Nameable value : values) {
            this.put(value);
        }
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public void remove(T val) {
        this.remove(val.getName());
    }

    public void removeAll(String ... keys) {
        for (String key : keys) {
            this.remove(key);
        }
    }

    public void removeAll(T ... values) {
        for (T key : values) {
            this.remove(key.getName());
        }
    }

    public void removeAll(Collection<? extends T> values) {
        for (Nameable key : values) {
            this.remove(key.getName());
        }
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void printAll(PrintStream stream) {
        stream.println("> Storage : class=[" + this.getClass() + "]");
        for (Nameable obj : this.map.values()) {
            stream.println("> Storage : printAll : " + obj.getName());
        }
        stream.println("> Storage : ------------------------");
    }

    public void printAll(PrintStream stream, boolean valueOut) {
        stream.println("> Storage : class=[" + this.getClass() + "]");
        for (Nameable obj : this.map.values()) {
            stream.print("> Storage : printAll : " + obj.getName());
            if (valueOut) {
                stream.print(" : " + obj);
            }
            stream.println();
        }
        stream.println("> Storage : ------------------------");
    }

    public Map<String, T> getProperties(String ... names) {
        HashMap<String, T> result = new HashMap<String, T>(names.length);
        for (String name : names) {
            if (!this.contains(name)) continue;
            result.put(name, this.get(name));
        }
        return result;
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public void forEach(Consumer<? super T> c) {
        this.asList().forEach(c);
    }

    public String toString() {
        return "Storage{map=" + this.map + "}";
    }
}

