/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.resource;

import java.io.Serializable;
import kinugasa.game.input.InputState;
import kinugasa.resource.ReplayInputState;
import kinugasa.resource.Storage;
import kinugasa.util.Random;

public final class ReplayData
extends Storage<ReplayInputState>
implements Serializable {
    private static final long serialVersionUID = -7860006069807950463L;
    private long seed;

    public ReplayData() {
        this(60, 5.0f);
    }

    public ReplayData(int fps, float minute) {
        super((int)((float)fps * minute));
    }

    public ReplayData recStart(long seed) {
        this.seed = seed;
        Random.initSeed(this.seed);
        return this;
    }

    public ReplayData recStart() {
        return this.recStart(System.nanoTime());
    }

    public void playStart() {
        Random.initSeed(this.seed);
    }

    public void add(long frame, InputState inputState) {
        super.add(new ReplayInputState(frame, inputState));
    }

    public InputState get(long frame) {
        ReplayInputState state = (ReplayInputState)super.getIfContains(Long.toString(frame));
        return state == null ? null : state.getInputState();
    }
}

