/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import kinugasa.game.GameLog;
import kinugasa.resource.ContentsIOException;
import kinugasa.resource.FileNotFoundException;

public final class ContentsIO {
    private ContentsIO() {
    }

    public static <T extends Serializable> void save(T obj, String filePath) throws FileNotFoundException, ContentsIOException {
        ContentsIO.save(obj, new File(filePath));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> void save(T obj, File file) throws FileNotFoundException, ContentsIOException {
        ObjectOutputStream stream = null;
        try {
            stream = new ObjectOutputStream(new FileOutputStream(file));
            stream.writeObject(obj);
            return;
        }
        catch (java.io.FileNotFoundException ex) {
            throw new FileNotFoundException(ex);
        }
        catch (IOException ex) {
            throw new ContentsIOException(ex);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ex) {
                throw new ContentsIOException(ex);
            }
            finally {
                GameLog.printInfoIfUsing("> ContentsIO : save : obj=[" + obj + "] file=[" + file.getPath() + "]");
            }
        }
    }

    public static <T extends Serializable> T load(Class<T> type, String filePath) throws FileNotFoundException, ContentsIOException {
        return ContentsIO.load(type, new File(filePath));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T load(Class<T> type, File file) throws FileNotFoundException, ContentsIOException {
        ObjectInputStream stream = null;
        try {
            stream = new ObjectInputStream(new FileInputStream(file));
            Serializable serializable = (Serializable)type.cast(stream.readObject());
            return (T)serializable;
        }
        catch (java.io.FileNotFoundException ex) {
            throw new FileNotFoundException(ex);
        }
        catch (IOException ex) {
            throw new ContentsIOException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new ContentsIOException(ex);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ex) {
                throw new ContentsIOException(ex);
            }
            finally {
                GameLog.printInfoIfUsing("> ContentsIO : load : type=[" + type + "] file=[" + file.getPath() + "]");
            }
        }
    }
}

