/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.object.movemodel;

import kinugasa.object.BasicSprite;
import kinugasa.object.MovingModel;

public class AngleChange
extends MovingModel {
    private float addDir;
    private float startDir = Float.NaN;
    private float spread = Float.POSITIVE_INFINITY;
    private float angSum = 0.0f;

    public AngleChange(float add) {
        this.addDir = add;
    }

    public AngleChange(float add, float spread) {
        this.addDir = add;
        this.spread = spread;
    }

    public float getAddDir() {
        return this.addDir;
    }

    public void setAddDir(float addDir) {
        this.addDir = addDir;
    }

    public float getSpread() {
        return this.spread;
    }

    public void setSpread(float spread) {
        this.spread = spread;
    }

    public float getStartDir() {
        return this.startDir;
    }

    @Override
    public void move(BasicSprite s) {
        if (this.startDir == Float.NaN) {
            this.startDir = s.getVector().getAngle();
        }
        if (this.angSum < this.spread) {
            s.getVector().addAngle(this.addDir);
            this.angSum += Math.abs(this.addDir);
        }
        s.setX(s.getX() + s.getVector().getX());
        s.setY(s.getY() + s.getVector().getY());
    }

    @Override
    public AngleChange clone() {
        return (AngleChange)super.clone();
    }
}

