/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.test.stgtest;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import kinugasa.game.GameLogic;
import kinugasa.game.GameManager;
import kinugasa.game.GameTimeManager;
import kinugasa.game.GraphicsContext;
import kinugasa.game.event2.Event;
import kinugasa.game.event2.EventManager;
import kinugasa.game.input.InputState;
import kinugasa.game.test.stgtest.MyShip;
import kinugasa.game.test.stgtest.Star;
import kinugasa.game.test.stgtest.Tama;
import kinugasa.game.ui.ActionImageSprite;
import kinugasa.game.ui.FontModel;
import kinugasa.game.ui.SimpleTextLabelModel;
import kinugasa.game.ui.TextLabelSprite;
import kinugasa.graphics.GraphicsUtil;
import kinugasa.object.BasicSprite;
import kinugasa.object.Sprite;
import kinugasa.object.TVector;
import kinugasa.resource.sound.LoopPoint;
import kinugasa.resource.sound.Sound;
import kinugasa.resource.sound.SoundBuilder;
import kinugasa.util.FrameTimeCounter;
import kinugasa.util.Random;
import kinugasa.util.TimeCounter;

public class Stage1Logic
extends GameLogic {
    private Sound bgm;
    private TextLabelSprite stage1;
    private TimeCounter stage1counter;
    private boolean trMode = false;
    private List<Star> stares;
    private TextLabelSprite fps;
    private ActionImageSprite ship;
    private List<Sprite> deleteList = new ArrayList<Sprite>();
    private List<BasicSprite> tama = new ArrayList<BasicSprite>();
    private TimeCounter tamaTc = new FrameTimeCounter(4);
    private EventManager em;
    private List<BasicSprite> tekiList = new ArrayList<BasicSprite>();
    private Rectangle DELETE_AREA;
    private boolean first = true;

    public Stage1Logic(String name, GameManager gm) {
        super(name, gm);
    }

    @Override
    public void load() {
        this.DELETE_AREA = new Rectangle(-9, -9, this.gm.getWindow().getWidth() + 18, this.gm.getWindow().getHeight() + 18);
        this.bgm = new SoundBuilder("resource/\u30b7\u30e5\u30fc\u30c6\u30a3\u30f3\u30b0\u30fb\u30b9\u30c6\u30fc\u30b8\uff11.wav").setLoopPoint(LoopPoint.END_TO_START).builde().load();
        this.bgm.play();
        this.stage1 = new TextLabelSprite("STAGE 1", new SimpleTextLabelModel(FontModel.DEFAULT.clone().setFontSize(32.0f)), 24.0f, 24.0f);
        this.stage1counter = new FrameTimeCounter(45);
        this.stares = new ArrayList<Star>();
        for (int i = 0; i < 32; ++i) {
            this.stares.add(new Star(GraphicsUtil.randomColor(), Random.randomAbsInt(720), Random.randomAbsInt(480), Random.randomAbsInt(6), 2.0f + Random.randomFloat(8.0f)));
        }
        this.fps = new TextLabelSprite("FPS:", new SimpleTextLabelModel(FontModel.DEFAULT.clone().setFontSize(16.0f)), 620.0f, 12.0f);
        this.ship = new MyShip(320, 300, 48, 48);
        this.em = new EventManager();
        this.em.readFromXML("resource/eventList.xml");
    }

    @Override
    public void dispose() {
        this.bgm.stop();
        this.bgm.dispose();
    }

    @Override
    public void update(GameTimeManager gtm) {
        if (this.first) {
            gtm.resetTotalFrame();
            this.first = false;
        }
        if (this.trMode) {
            this.stage1.getLabelModel().getFontConfig().addAlpha(-2);
            if (this.stage1.getLabelModel().getFontConfig().getColor().getAlpha() == 0) {
                this.stage1.setVisible(false);
            }
        }
        if (!this.trMode && this.stage1counter.isReaching()) {
            this.trMode = true;
        }
        this.stares.forEach(Star::update);
        this.fps.setText("FPS:" + gtm.getFPSStr(2));
        this.ship.setVector(new TVector(InputState.getInstance().getGamePadState().sticks.LEFT.getLocation(4.5f)));
        this.ship.move();
        if (this.ship.getX() <= 0.0f) {
            this.ship.setX(1.0f);
        }
        if (this.ship.getY() <= 0.0f) {
            this.ship.setY(1.0f);
        }
        if (this.ship.getX() + this.ship.getWidth() >= (float)this.gm.getWindow().getInternalBounds().width) {
            this.ship.setX((float)this.gm.getWindow().getInternalBounds().width - this.ship.getWidth() - 1.0f);
        }
        if (this.ship.getY() + this.ship.getHeight() >= (float)this.gm.getWindow().getInternalBounds().height) {
            this.ship.setY((float)this.gm.getWindow().getInternalBounds().height - this.ship.getHeight() - 1.0f);
        }
        if (InputState.getInstance().getGamePadState().buttons.A && this.tamaTc.isReaching()) {
            Tama t1 = new Tama(this.ship.getX() + 26.0f, this.ship.getY() + 22.0f, 8, 8, "resource/tama.png");
            Tama tama = new Tama(this.ship.getX() + 12.0f, this.ship.getY() + 22.0f, 8, 8, "resource/tama.png");
            t1.setVector(new TVector(0.0f, 12.0f));
            tama.setVector(new TVector(0.0f, 12.0f));
            this.tama.add(t1);
            this.tama.add(tama);
            this.tamaTc.reset();
        }
        for (Sprite sprite : this.tama) {
            if (sprite.isExist()) continue;
            this.deleteList.add(sprite);
        }
        this.tama.removeAll(this.deleteList);
        this.deleteList.clear();
        this.tama.forEach(BasicSprite::move);
        if (this.em.hasEvent(gtm.getTotalFrame())) {
            List<Event<?>> eList = this.em.getEvents(gtm.getTotalFrame());
            for (Event<?> event : eList) {
                Object o = event.exec();
                if (!(o instanceof BasicSprite)) continue;
                this.tekiList.add((BasicSprite)o);
            }
        }
        for (BasicSprite basicSprite : this.tama) {
            for (BasicSprite t : this.tekiList) {
                if (!t.contains(basicSprite.getCenter())) continue;
                t.setExist(false);
                this.deleteList.add(t);
            }
        }
        for (BasicSprite basicSprite : this.tekiList) {
            if (!basicSprite.isExist()) continue;
            basicSprite.move();
            if (this.DELETE_AREA.contains(basicSprite.getCenter())) continue;
            this.deleteList.add(basicSprite);
        }
        this.tekiList.removeAll(this.deleteList);
        this.deleteList.clear();
    }

    @Override
    public void draw(GraphicsContext g) {
        this.stage1.draw(g);
        this.stares.forEach(s -> s.draw(g));
        this.fps.draw(g);
        this.tekiList.forEach(s -> s.draw(g));
        this.tama.forEach(s -> s.draw(g));
        this.ship.draw(g);
    }
}

