/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.rpgui;

import java.awt.image.BufferedImage;
import java.util.List;
import kinugasa.game.GameLog;
import kinugasa.game.rpgui.MessageWindowModel;
import kinugasa.game.rpgui.MessageWindowModelStorage;
import kinugasa.game.rpgui.MessageWindowSprite;
import kinugasa.game.rpgui.Text;
import kinugasa.graphics.Animation;
import kinugasa.graphics.ImageUtil;
import kinugasa.graphics.SpriteSheet;
import kinugasa.object.AnimationSprite;
import kinugasa.object.ImagePainter;
import kinugasa.object.ImagePainterStorage;
import kinugasa.resource.ContentsIOException;
import kinugasa.resource.Disposable;
import kinugasa.resource.Storage;
import kinugasa.resource.sound.CachedSound;
import kinugasa.resource.sound.SoundBuilder;
import kinugasa.resource.text.FileNotFoundException;
import kinugasa.resource.text.IllegalXMLFormatException;
import kinugasa.resource.text.XMLAttribute;
import kinugasa.resource.text.XMLElement;
import kinugasa.resource.text.XMLFile;
import kinugasa.resource.text.XMLFileSupport;
import kinugasa.util.FrameTimeCounter;
import kinugasa.util.StopWatch;
import kinugasa.util.StringUtil;
import kinugasa.util.TimeCounter;

public final class TextStorage
extends Storage<Text>
implements XMLFileSupport,
Disposable {
    private MessageWindowSprite messageWindowSprite;

    @Override
    public void readFromXML(String filePath) throws IllegalXMLFormatException, FileNotFoundException, ContentsIOException {
        StopWatch watch = new StopWatch().start();
        XMLFile reader = new XMLFile(filePath).load();
        XMLElement root = reader.getFirst();
        if (!"kinugasaMessageWindowText".equals(root.getName())) {
            throw new IllegalXMLFormatException("illegal root node name :" + root);
        }
        XMLElement messageWindowElement = root.getElement("messageWindow").get(0);
        int x = ((XMLAttribute)messageWindowElement.getAttributes().get("x")).getIntValue();
        int y = ((XMLAttribute)messageWindowElement.getAttributes().get("y")).getIntValue();
        int width = ((XMLAttribute)messageWindowElement.getAttributes().get("width")).getIntValue();
        int height = ((XMLAttribute)messageWindowElement.getAttributes().get("height")).getIntValue();
        int length = ((XMLAttribute)messageWindowElement.getAttributes().get("length")).getIntValue();
        MessageWindowModel windowModel = (MessageWindowModel)MessageWindowModelStorage.getInstance().get(((XMLAttribute)messageWindowElement.getAttributes().get("messageWindowModelName")).getValue());
        this.messageWindowSprite = new MessageWindowSprite(windowModel, (float)x, (float)y, (float)width, (float)height);
        this.messageWindowSprite.setLineLength(length);
        if (messageWindowElement.hasElement("continueIcon")) {
            this.messageWindowSprite.setContinueIcon(this.createContinueIcon(messageWindowElement.getElement("continueIcon").get(0)));
        }
        List<XMLElement> textElementList = messageWindowElement.getElement("text");
        int size = textElementList.size();
        for (int i = 0; i < size; ++i) {
            XMLElement textElement = textElementList.get(i);
            String textId = ((XMLAttribute)textElement.getAttributes().get("id")).getValue();
            CachedSound sound = null;
            if (textElement.hasElement("sound")) {
                XMLElement soundElement = textElement.getElement("sound").get(0);
                String file = ((XMLAttribute)soundElement.getAttributes().get("file")).getValue();
                float volume = 1.0f;
                if (soundElement.getAttributes().contains("volume")) {
                    volume = ((XMLAttribute)soundElement.getAttributes().get("volume")).getFloatValue();
                }
                sound = new SoundBuilder(file).setMasterGain(volume).builde();
            }
            FrameTimeCounter timeCounter = new FrameTimeCounter(StringUtil.parseIntCSV(((XMLAttribute)textElement.getElement("speed").get(0).getAttributes().get("frame")).getValue(), ","));
            String message = textElement.getElement("message").get(0).getValue();
            String[] nextId = null;
            if (textElement.hasElement("next")) {
                nextId = new String[textElement.getElement("next").size()];
                List<XMLElement> nextIdElements = textElement.getElement("next");
                int nextIdSize = nextId.length;
                for (int j = 0; j < nextIdSize; ++j) {
                    nextId[j] = ((XMLAttribute)nextIdElements.get(j).getAttributes().get("id")).getValue();
                }
            }
            this.add(new Text(textId, sound, (TimeCounter)timeCounter, message, nextId));
        }
        this.messageWindowSprite.setTextStorage(this);
        watch.stop();
        GameLog.printInfo("\u30c6\u30ad\u30b9\u30c8\u304c\u30ed\u30fc\u30c9\u3055\u308c\u307e\u3057\u305f name=[" + reader.getName() + "] (" + watch.getTime() + " ms)");
        List text = this.asList();
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            GameLog.printInfo("- " + text.get(i));
        }
    }

    public Text[] getNextText(Text text) {
        if (!text.hasNext()) {
            GameLog.printInfo("NextText\u304c\u8981\u6c42\u3055\u308c\u307e\u3057\u305f\u304c\u3001\u6b21\u306e\u30c6\u30ad\u30b9\u30c8\u304c\u3042\u308a\u307e\u305b\u3093 text=[" + text + "]");
            return null;
        }
        String[] nextId = text.getNextId();
        Text[] result = new Text[nextId.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Text)this.get(nextId[i]);
        }
        return result;
    }

    public MessageWindowSprite getMessageWindowSprite() {
        return this.messageWindowSprite;
    }

    @Override
    public void dispose() {
        this.clear();
    }

    private AnimationSprite createContinueIcon(XMLElement continueIconElement) {
        int x = ((XMLAttribute)continueIconElement.getAttributes().get("x")).getIntValue();
        int y = ((XMLAttribute)continueIconElement.getAttributes().get("y")).getIntValue();
        int width = ((XMLAttribute)continueIconElement.getAttributes().get("width")).getIntValue();
        int height = ((XMLAttribute)continueIconElement.getAttributes().get("height")).getIntValue();
        FrameTimeCounter tc = new FrameTimeCounter(StringUtil.parseIntCSV(((XMLAttribute)continueIconElement.getAttributes().get("frame")).getValue()));
        ImagePainter painter = (ImagePainter)ImagePainterStorage.getInstance().get(((XMLAttribute)continueIconElement.getAttributes().get("painterName")).getValue());
        boolean visible = ((XMLAttribute)continueIconElement.getAttributes().get("visible")).getBool();
        Animation animation = null;
        if (continueIconElement.hasElement("image")) {
            animation = this.createAnimationByImage(continueIconElement.getElement("image"), tc);
        } else if (continueIconElement.hasElement("spriteSheet")) {
            animation = this.createAnimationBySpriteSheet(continueIconElement.getElement("spriteSheet").get(0), tc);
        }
        AnimationSprite sprite = new AnimationSprite((float)x, (float)y, (float)width, (float)height, animation, painter);
        sprite.setVisible(visible);
        return sprite;
    }

    private Animation createAnimationBySpriteSheet(XMLElement element, FrameTimeCounter tc) {
        int x = ((XMLAttribute)element.getAttributes().get("x")).getIntValue();
        int y = ((XMLAttribute)element.getAttributes().get("y")).getIntValue();
        int width = ((XMLAttribute)element.getAttributes().get("width")).getIntValue();
        int height = ((XMLAttribute)element.getAttributes().get("height")).getIntValue();
        String baseImagePath = ((XMLAttribute)element.getAttributes().get("src")).getValue();
        BufferedImage[] images = null;
        if ("SPLIT".equals(((XMLAttribute)element.getAttributes().get("cutType")).getValue())) {
            images = new SpriteSheet(baseImagePath).split(width, height).images();
        } else if ("COLUMN".equals(((XMLAttribute)element.getAttributes().get("cutType")).getValue())) {
            images = new SpriteSheet(baseImagePath).columns(x, width, height).images();
        } else if ("ROW".equals(((XMLAttribute)element.getAttributes().get("cutType")).getValue())) {
            images = new SpriteSheet(baseImagePath).rows(y, width, height).images();
        }
        return new Animation((TimeCounter)tc, images);
    }

    private Animation createAnimationByImage(List<XMLElement> imageElements, FrameTimeCounter tc) {
        SpriteSheet spriteSheet = new SpriteSheet();
        int size = imageElements.size();
        for (int i = 0; i < size; ++i) {
            XMLElement element = imageElements.get(i);
            String baseImagePath = ((XMLAttribute)element.getAttributes().get("src")).getValue();
            if (element.hasElement("cutter")) {
                XMLElement cutterElement = element.getElement("cutter").get(0);
                int x = ((XMLAttribute)cutterElement.getAttributes().get("x")).getIntValue();
                int y = ((XMLAttribute)cutterElement.getAttributes().get("y")).getIntValue();
                int width = ((XMLAttribute)cutterElement.getAttributes().get("width")).getIntValue();
                int height = ((XMLAttribute)cutterElement.getAttributes().get("height")).getIntValue();
                spriteSheet.add(ImageUtil.trimming(ImageUtil.load(baseImagePath), x, y, width, height));
                continue;
            }
            spriteSheet.add(ImageUtil.load(baseImagePath));
        }
        return new Animation((TimeCounter)tc, spriteSheet.images());
    }
}

