/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.rpgui;

import java.util.Arrays;
import kinugasa.resource.InputStatus;
import kinugasa.resource.Nameable;
import kinugasa.resource.sound.Sound;
import kinugasa.util.TimeCounter;

public class Text
implements Nameable,
Comparable<Text> {
    private static int instanceCount = 0;
    private final String id;
    private Sound sound;
    private TimeCounter timeCounter;
    private String message;
    private String[] nextId;
    private String[] splitResult = null;
    private int prevSplitLength = -1;
    private int visibleTextLength;
    private static String BR = "\n";

    public Text() {
        this(Integer.toString(instanceCount++), (Sound)null, TimeCounter.TRUE, "");
    }

    public Text(String message, TimeCounter tc) {
        this(Integer.toString(instanceCount++), (Sound)null, tc, message);
    }

    public Text(String id, Sound sound, TimeCounter timeCounter, String message, String ... nextId) {
        this.id = id;
        this.sound = sound;
        this.timeCounter = timeCounter;
        this.message = message;
        this.nextId = nextId;
    }

    public Text(String id, Sound sound, TimeCounter timeCounter, String message) {
        this.id = id;
        this.sound = sound;
        this.timeCounter = timeCounter;
        this.message = message;
        this.nextId = null;
    }

    public Text(String id, String message, TimeCounter timeCounter, String ... nextId) {
        this.id = id;
        this.sound = null;
        this.timeCounter = timeCounter;
        this.message = message;
        this.nextId = nextId;
    }

    public Text(String id, String message, TimeCounter timeCounter) {
        this.id = id;
        this.sound = null;
        this.timeCounter = timeCounter;
        this.message = message;
        this.nextId = null;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public int compareTo(Text o) {
        return this.id.compareTo(o.id);
    }

    public Sound getSound() {
        return this.sound;
    }

    public String getMessage() {
        return this.message;
    }

    public String[] getNextId() {
        return this.nextId;
    }

    public boolean hasNext() {
        return this.nextId != null;
    }

    public int getNextIdNum() {
        return this.nextId.length;
    }

    public boolean hasSound() {
        return this.sound != null;
    }

    public TimeCounter getTimeCounter() {
        return this.timeCounter;
    }

    public void setSound(Sound sound) {
        this.sound = sound;
    }

    public void setTimeCounter(TimeCounter timeCounter) {
        this.timeCounter = timeCounter;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setNextId(String[] nextId) {
        this.nextId = nextId;
    }

    public static String getBR() {
        return BR;
    }

    public static void setBR(String BR) {
        Text.BR = BR;
    }

    public String[] split(int length) {
        if (this.prevSplitLength != this.visibleTextLength) {
            StringBuilder val = new StringBuilder(this.message.substring(0, this.visibleTextLength));
            for (int i = length; i < val.length(); i += length) {
                val.insert(i, BR);
            }
            this.prevSplitLength = this.visibleTextLength;
            this.splitResult = val.toString().split(BR);
            return this.splitResult;
        }
        return this.splitResult;
    }

    public String[] split(String val) {
        return this.message.substring(0, this.visibleTextLength).split(val);
    }

    public boolean isReaching() {
        return this.timeCounter.isReaching();
    }

    public void nextChar() {
        if (this.isVisibleAllChar()) {
            return;
        }
        if (this.sound != null) {
            if (this.sound.getStatus() != InputStatus.LOADED) {
                this.sound.load();
            }
            this.sound.again();
        }
        ++this.visibleTextLength;
    }

    public void prevChar() {
        this.visibleTextLength -= this.visibleTextLength == 0 ? 0 : 1;
    }

    public void allChar() {
        this.visibleTextLength = this.message.length();
    }

    public Text reset() {
        this.timeCounter.reset();
        this.visibleTextLength = 0;
        return this;
    }

    public boolean isVisibleAllChar() {
        return this.visibleTextLength == this.message.length();
    }

    public void setVisibleTextLength(int visibleTextLength) {
        this.visibleTextLength = visibleTextLength;
    }

    public int getVisibleTextLength() {
        return this.visibleTextLength;
    }

    public String getVisibleText() {
        return this.message.substring(0, this.visibleTextLength);
    }

    public boolean isReachingNextCher() {
        if (this.isReaching()) {
            this.nextChar();
            return true;
        }
        return false;
    }

    public String toString() {
        return "Text{id=" + this.id + ", sound=" + this.sound + ", message=" + this.message + ", nextId=" + Arrays.toString(this.nextId) + "}";
    }
}

