/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.rpgui;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import kinugasa.game.GameLog;
import kinugasa.game.rpgui.ChipSet;
import kinugasa.game.rpgui.MapChip;
import kinugasa.game.rpgui.MapData;
import kinugasa.graphics.ImageUtil;
import kinugasa.graphics.RenderingQuality;

public class CSVMapData
implements MapData {
    private static final long serialVersionUID = -4149183153471102531L;
    private ChipSet chipSet;
    public String[] csvValue;
    private MapChip[][] chips;
    private BufferedImage image;
    private int chipWidth;
    private int chipHeight;

    public CSVMapData(ChipSet chipSet, String[] values, int chipWidth, int chipHeight) {
        this.chipSet = chipSet;
        this.csvValue = values;
        this.chipWidth = chipWidth;
        this.chipHeight = chipHeight;
        this.builde();
    }

    @Override
    public void dispose() {
        this.chipSet = null;
        this.csvValue = null;
        this.chips = null;
        this.image = null;
        GameLog.printInfo("MapData\u304cdispose\u3055\u308c\u307e\u3057\u305f chipSet=[" + this.chipSet + "]");
    }

    private void builde() {
        ArrayList<String[]> csvData = new ArrayList<String[]>(this.csvValue.length);
        int yChipNum = this.csvValue.length;
        int xChipNum = -1;
        for (String line : this.csvValue) {
            String[] lineData = line.split(",");
            if (xChipNum < lineData.length) {
                xChipNum = lineData.length;
            }
            csvData.add(lineData);
        }
        this.image = ImageUtil.newImage(xChipNum * (this.chipSet.getCutWidth() * (this.chipWidth / this.chipSet.getCutWidth())), yChipNum * (this.chipSet.getCutHeight() * (this.chipHeight / this.chipSet.getCutHeight())));
        Graphics2D g = ImageUtil.createGraphics2D(this.image, RenderingQuality.SPEED);
        this.chips = new MapChip[yChipNum][xChipNum];
        for (int y = 0; y < yChipNum; ++y) {
            String[] line = (String[])csvData.get(y);
            this.chips[y] = new MapChip[line.length];
            for (int x = 0; x < xChipNum; ++x) {
                this.chips[y][x] = (MapChip)this.chipSet.get(line[x]);
                g.drawImage(this.chips[y][x].getImage(), x * (this.chips[y][x].getImage().getWidth() * (this.chipWidth / this.chips[y][x].getImage().getWidth())), y * (this.chips[y][x].getImage().getHeight() * (this.chipHeight / this.chips[y][x].getImage().getHeight())), this.chips[y][x].getImage().getWidth() * (this.chipWidth / this.chips[y][x].getImage().getWidth()), this.chips[y][x].getImage().getHeight() * (this.chipHeight / this.chips[y][x].getImage().getHeight()), null);
            }
        }
        g.dispose();
    }

    @Override
    public ChipSet getChipSet() {
        return this.chipSet;
    }

    public String[] getCsvValue() {
        return this.csvValue;
    }

    @Override
    public MapChip[][] getChips() {
        return this.chips;
    }

    @Override
    public BufferedImage getImage() {
        return this.image;
    }

    public String toString() {
        return "CSVMapData{chipSet=" + this.chipSet + ", csvValue=" + this.csvValue + ", chips=" + this.chips + ", image=" + this.image + "}";
    }
}

