/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.input;

import kinugasa.game.PlayerConstants;
import kinugasa.game.input.GamePadButton;
import kinugasa.game.input.GamePadConnection;
import kinugasa.game.input.GamePadState;
import kinugasa.game.input.InputDeviceState;
import kinugasa.game.input.InputType;
import kinugasa.game.input.KeyConnection;
import kinugasa.game.input.KeyState;
import kinugasa.game.input.Keys;
import kinugasa.game.input.MouseButtons;
import kinugasa.game.input.MouseConnection;
import kinugasa.game.input.MouseState;

public final class InputState
extends InputDeviceState {
    private static final long serialVersionUID = 2349722781837661059L;
    private KeyState keyState = null;
    private KeyState prevKeyState = null;
    private MouseState mouseState = null;
    private MouseState prevMouseState = null;
    private static final InputState INSTANCE = new InputState();
    private GamePadState gpState;
    private GamePadState prevGpState;

    private InputState() {
        if (PlayerConstants.getInstance().isUsingKeyboard()) {
            this.keyState = KeyConnection.createClearState();
        }
        if (PlayerConstants.getInstance().isUsingMouse()) {
            this.mouseState = MouseConnection.createClearState();
        }
    }

    public static InputState getInstance() {
        INSTANCE.refresh();
        return INSTANCE;
    }

    private void refresh() {
        if (PlayerConstants.getInstance().isUsingMouse()) {
            this.prevMouseState = this.mouseState;
            this.mouseState = MouseConnection.getState();
        }
        if (PlayerConstants.getInstance().isUsingKeyboard()) {
            this.prevKeyState = this.keyState;
            this.keyState = KeyConnection.getState();
        }
        if (PlayerConstants.getInstance().isUsingGamePad()) {
            this.prevGpState = this.gpState;
            this.gpState = new GamePadState(GamePadConnection.getNativeState(0));
        }
    }

    @Override
    public boolean isAnyInput() {
        boolean result = false;
        if (PlayerConstants.getInstance().isUsingMouse()) {
            result |= this.mouseState.isAnyInput();
        }
        if (PlayerConstants.getInstance().isUsingGamePad()) {
            result |= this.gpState.isAnyInput();
        }
        return result | this.keyState.isAnyInput();
    }

    @Override
    public boolean isAnyButtonInput() {
        boolean result = false;
        if (PlayerConstants.getInstance().isUsingMouse()) {
            result |= this.mouseState.isAnyButtonInput();
        }
        if (PlayerConstants.getInstance().isUsingGamePad()) {
            result |= this.gpState.isAnyInput();
        }
        return result | this.keyState.isAnyButtonInput();
    }

    @Override
    public boolean isEmptyInput() {
        boolean result = true;
        if (PlayerConstants.getInstance().isUsingMouse()) {
            result &= this.mouseState.isEmptyInput();
        }
        if (PlayerConstants.getInstance().isUsingGamePad()) {
            result &= this.gpState.isEmptyInput();
        }
        return result & this.keyState.isEmptyInput();
    }

    public boolean isPressed(Keys key, InputType type) {
        return type == InputType.CONTINUE ? this.keyState.isPressed(key) : this.keyState.isPressed(key) && !this.prevKeyState.isPressed(key);
    }

    public boolean isPressedOr(InputType type, Keys ... keys) {
        boolean result = false;
        for (Keys key : keys) {
            result |= this.isPressed(key, type);
        }
        return result;
    }

    public boolean isPressedAnd(InputType type, Keys ... keys) {
        for (Keys key : keys) {
            if (this.isPressed(key, type)) continue;
            return false;
        }
        return true;
    }

    public boolean isPressed(MouseButtons button, InputType type) {
        if (!PlayerConstants.getInstance().isUsingMouse()) {
            return false;
        }
        return type == InputType.CONTINUE ? this.mouseState.isPressed(button) : this.mouseState.isPressed(button) && !this.prevMouseState.isPressed(button);
    }

    public KeyState getKeyState() {
        return this.keyState;
    }

    public KeyState getPrevKeyState() {
        return this.prevKeyState;
    }

    public MouseState getPrevMouseState() {
        return this.prevMouseState;
    }

    public MouseState getMouseState() {
        return this.mouseState;
    }

    public GamePadState getGamePadState() {
        return this.gpState;
    }

    public boolean isPressed(GamePadButton button, InputType type) {
        if (!PlayerConstants.getInstance().isUsingMouse()) {
            return false;
        }
        return type == InputType.CONTINUE ? this.gpState.buttons.isPressed(button) : this.gpState.buttons.isPressed(button) && !this.prevGpState.buttons.isPressed(button);
    }

    @Override
    public InputState clone() {
        InputState result = (InputState)super.clone();
        if (this.mouseState != null) {
            result.mouseState = this.mouseState.clone();
        }
        if (this.prevMouseState != null) {
            result.prevMouseState = this.prevMouseState.clone();
        }
        if (this.keyState != null) {
            result.keyState = this.keyState.clone();
        }
        if (this.prevKeyState != null) {
            result.prevKeyState = this.prevKeyState.clone();
        }
        if (this.gpState != null) {
            result.gpState = this.gpState.clone();
        }
        if (this.prevGpState != null) {
            result.prevGpState = this.prevGpState.clone();
        }
        return result;
    }

    public String toString() {
        return "InputState{keyState=" + this.keyState + ", prevKeyState=" + this.prevKeyState + ", mouseState=" + this.mouseState + ", prevMouseState=" + this.prevMouseState + "}";
    }
}

