/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.event;

import java.io.Serializable;
import kinugasa.game.event.EntryModel;

public abstract class TimeEvent<T>
implements Comparable<TimeEvent<?>>,
Serializable {
    public static final long TIME_INITIAL = 0L;
    public static final long TIME_NOT_EXECUTE = -1L;
    private static int idCounter = 0;
    private int id = ++idCounter;
    private long executeTime;
    private EntryModel entryModel;
    protected final T object;
    private Class<T> type;

    public TimeEvent(long executeTime, EntryModel entryModel, T obj) throws IllegalArgumentException, NullPointerException {
        if (executeTime < -1L) {
            throw new IllegalArgumentException("executeTime < NOT_EXECUTE :  id=[" + this.id + "], time=[" + executeTime + "]");
        }
        if (obj == null) {
            throw new NullPointerException("event obj == null id=" + this.id + "]");
        }
        this.executeTime = executeTime;
        this.entryModel = entryModel;
        this.object = obj;
        this.type = obj.getClass();
    }

    public final int getId() {
        return this.id;
    }

    public static int getEventsNum() {
        return idCounter;
    }

    public final void setEntryModel(EntryModel entryModel) {
        this.entryModel = entryModel;
    }

    public final EntryModel getEntryModel() {
        return this.entryModel;
    }

    public final boolean isReaching() {
        return this.executeTime == -1L ? false : this.entryModel.isReaching(this);
    }

    public final long getExecuteTime() {
        return this.executeTime;
    }

    @Override
    public final int compareTo(TimeEvent<?> o) {
        return this.executeTime > o.executeTime ? 1 : (this.executeTime < o.executeTime ? -1 : 0);
    }

    public final T getObject() {
        return this.object;
    }

    public final Class<T> getType() {
        return this.type;
    }

    public abstract T execute();

    public String toString() {
        return "Event{id=" + this.id + ", executeTime=" + this.executeTime + ", type=" + this.type + "}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeEvent other = (TimeEvent)obj;
        return this.id == other.id;
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + this.id;
        return hash;
    }
}

