/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import kinugasa.game.GameLog;
import kinugasa.game.event.EventManager;
import kinugasa.game.event.TimeEvent;
import kinugasa.resource.NotYetLoadedException;

public abstract class SingleClassEventManager<T extends Serializable>
extends EventManager {
    private static final long serialVersionUID = 576975168711401996L;
    private List<TimeEvent<T>> events;

    public SingleClassEventManager() {
        this(32);
    }

    public SingleClassEventManager(int initialSize) {
        this.events = new ArrayList<TimeEvent<T>>(initialSize);
    }

    @Override
    protected abstract void init();

    @Override
    public SingleClassEventManager<T> load() {
        return (SingleClassEventManager)super.load();
    }

    @Override
    public SingleClassEventManager<T> free() {
        return (SingleClassEventManager)super.free();
    }

    @Override
    public void printAll() {
        int size = this.events.size();
        for (int i = 0; i < size; ++i) {
            GameLog.printInfo("-" + this.events.get(i));
        }
    }

    @Override
    public void sort() {
        Collections.sort(this.events);
    }

    @Override
    public int size() {
        return this.events.size();
    }

    @Override
    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    @Override
    public void clear() {
        this.events.clear();
    }

    @Override
    public boolean contains(TimeEvent<?> evt) {
        return this.events.contains(evt);
    }

    @Override
    public void remove(TimeEvent<?> evt) {
        this.events.remove(evt);
    }

    @Override
    public void removeAll(TimeEvent<?> ... evt) {
        this.events.removeAll(Arrays.asList(evt));
    }

    public void add(TimeEvent<T> evt) {
        this.events.add(evt);
    }

    public void addAll(TimeEvent<T> ... evt) {
        this.events.addAll(Arrays.asList(evt));
    }

    public List<TimeEvent<T>> getEvents() {
        return this.events;
    }

    public TimeEvent<T> getNext() throws NotYetLoadedException {
        if (!this.isLoaded()) {
            throw new NotYetLoadedException("not yet loaded : load=[" + this.isLoaded() + "]");
        }
        if (this.isEmpty()) {
            return null;
        }
        return this.events.get(0);
    }

    public T execute() throws NotYetLoadedException {
        if (!this.isLoaded()) {
            throw new NotYetLoadedException("not yet loaded : load=[" + this.isLoaded() + "]");
        }
        if (!this.hasNext()) {
            return null;
        }
        TimeEvent<T> evt = this.events.get(0);
        GameLog.printIfUsing(Level.INFO, "> SingleClassEventManager : execute : now=[" + this.getProgressTime() + "] event=[" + evt + "]");
        this.remove(evt);
        return (T)((Serializable)evt.execute());
    }

    public boolean hasNext() throws NotYetLoadedException {
        if (!this.isLoaded()) {
            throw new NotYetLoadedException("not yet loaded : load=[" + this.isLoaded() + "]");
        }
        if (this.isEmpty()) {
            return false;
        }
        return this.events.get(0).isReaching();
    }

    @Override
    public String toString() {
        return "SingleClassEventManager{load=" + this.isLoaded() + ", events=" + this.size() + ", progressTime=" + this.getProgressTime() + "}";
    }
}

