/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Level;
import kinugasa.game.GameLog;
import kinugasa.resource.ContentsIOException;

public final class LockUtil {
    public static final String LOCK_FILE_PREFIX = "KLOCK_";
    public static final String LOCK_FILE_SUFFIX = ".lck";
    public static final FilenameFilter TEMP_FN_FILTER = (dir, name) -> name.startsWith(LOCK_FILE_PREFIX) & name.endsWith(LOCK_FILE_SUFFIX);
    private static File lockFile;
    private static BufferedWriter writer;

    private LockUtil() {
    }

    static void createLockFile() throws ContentsIOException {
        try {
            lockFile = File.createTempFile(LOCK_FILE_PREFIX, LOCK_FILE_SUFFIX, new File("./"));
            writer = new BufferedWriter(new FileWriter(lockFile));
            writer.append(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(Calendar.getInstance().getTime()));
            writer.flush();
        }
        catch (IOException ex) {
            GameLog.print(Level.WARNING, ex);
        }
        GameLog.printInfoIfUsing("lockFile:" + lockFile.getPath() + " is created");
    }

    public static void deleteAllLockFile() {
        File[] list;
        for (File file : list = new File("./").listFiles(TEMP_FN_FILTER)) {
            file.delete();
            GameLog.printInfoIfUsing("lockFile:" + file.getPath() + " is deleted");
        }
    }

    static void deleteLockFile() {
        if (lockFile != null && lockFile.exists()) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                GameLog.print(Level.WARNING, ex);
            }
            lockFile.delete();
            GameLog.printInfoIfUsing("lockFile:" + lockFile.getPath() + " is deleted");
        }
    }

    static boolean isExistsLockFile() {
        return new File("./").list(TEMP_FN_FILTER).length != 0;
    }

    static String[] listLockFile() {
        return new File("./").list(TEMP_FN_FILTER);
    }
}

