/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game;

public final class GameTimeManager {
    private int updateNum;
    private long prevTime;
    private long nowTime;
    private float fps;
    private long waitTime;
    private long totalFrame = 0L;
    private long endTime;

    GameTimeManager() {
        this(60);
    }

    GameTimeManager(int idealFPS) {
        this.waitTime = 1000 / idealFPS * 1000000;
        this.updateNum = idealFPS;
        this.prevTime = System.nanoTime() - 1000000000L;
    }

    public long getIdealFPS() {
        return 1000000000L / this.waitTime;
    }

    public void setIdealFPS(int idealFPS) {
        this.waitTime = 1000 / idealFPS * 1000000;
        this.updateNum = idealFPS;
    }

    public float getFPS() {
        return this.fps;
    }

    public String getFPSStr() {
        return Float.toString(this.getFPS());
    }

    public String getFPSStr(int d) throws IllegalArgumentException {
        if (d < 0) {
            throw new IllegalArgumentException("disit is minus");
        }
        String s = this.getFPSStr();
        int dotPosition = s.indexOf(46);
        if (dotPosition <= 0) {
            return s;
        }
        if (d == 0) {
            return s.substring(0, dotPosition);
        }
        if (s.length() <= (dotPosition += d)) {
            return s;
        }
        return s.substring(0, dotPosition + 1);
    }

    public long getTotalFrame() {
        return this.totalFrame;
    }

    public void resetTotalFrame() {
        this.totalFrame = 0L;
    }

    void sleep(long startTime) {
        this.nowTime = System.nanoTime();
        this.endTime = this.nowTime + (this.waitTime - (this.nowTime - startTime));
        while (System.nanoTime() < this.endTime) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.nowTime = System.nanoTime();
        ++this.totalFrame;
        ++this.updateNum;
        if (this.nowTime - this.prevTime > 1000000000L) {
            this.fps = (float)this.updateNum / ((float)(this.nowTime - this.prevTime) / 1.0E9f);
            this.updateNum = 0;
            this.prevTime = this.nowTime;
        }
    }
}

