/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game;

import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import kinugasa.game.AWTGameWindow;
import kinugasa.game.GameLog;
import kinugasa.game.GameLoop;
import kinugasa.game.GameOption;
import kinugasa.game.GameTimeManager;
import kinugasa.game.GameWindow;
import kinugasa.game.GraphicsContext;
import kinugasa.game.I18N;
import kinugasa.game.LockUtil;
import kinugasa.game.PlayerConstants;
import kinugasa.game.input.GamePadConnection;
import kinugasa.game.input.KeyConnection;
import kinugasa.game.input.MouseConnection;
import kinugasa.graphics.ImageUtil;
import kinugasa.resource.TempFileStorage;
import kinugasa.util.MathUtil;

public abstract class GameManager {
    private GameOption option;
    private AWTGameWindow window;
    private GameLoop loop;
    private GameTimeManager gameTimeManager;
    private boolean updateIfNotActive;
    private Graphics2D g;
    private BufferStrategy graphicsBuffer;
    private Rectangle clippingRectangle;
    private RenderingHints renderingHints;
    private int fps;
    private boolean started = false;

    protected GameManager(GameOption option) throws IllegalStateException {
        this.option = option;
        this.updateOption();
    }

    protected final void updateOption() {
        MathUtil.init();
        if (this.option.isUseLog()) {
            GameLog.usingLog(this.option.getLogPath());
            try {
                FileHandler handler = new FileHandler(this.option.getLogPath());
                handler.setLevel(Level.ALL);
                handler.setFormatter(new Formatter(){
                    final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

                    @Override
                    public String format(LogRecord record) {
                        StringBuilder line = new StringBuilder();
                        line.append(this.DATE_FORMAT.format(new Date(record.getMillis()))).append(' ');
                        line.append(record.getLevel().getName()).append(' ');
                        if (record.getThrown() != null) {
                            line.append("(exception)").append(record.getThrown().getMessage());
                        } else {
                            line.append(record.getMessage());
                        }
                        line.append(System.lineSeparator());
                        return line.toString();
                    }
                });
                Logger.getGlobal().addHandler(handler);
            }
            catch (IOException | SecurityException ex) {
                GameLog.print(Level.WARNING, ex);
            }
            GameLog.printInfo("this is " + this.option.getLogPath());
        }
        I18N.init(this.option.getLang());
        if (this.option.isLock()) {
            if (LockUtil.isExistsLockFile()) {
                throw new IllegalStateException(Arrays.toString(LockUtil.listLockFile()));
            }
            LockUtil.createLockFile();
        }
        this.window = new AWTGameWindow();
        this.renderingHints = this.option.getRenderingQuality().getRenderingHints();
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (GameManager.this.option.getCloseEvent().isClose()) {
                    GameManager.this.gameExit();
                }
            }
        });
        this.window.setTitle(this.option.getTitle());
        this.window.setIconImage(this.option.getIcon().getImage());
        this.window.setBackground(this.option.getBackColor());
        this.window.setLocation(this.option.getWindowLocation());
        this.window.setSize(this.option.getWindowSize());
        this.window.setResizable(false);
        this.fps = this.option.getFps();
        this.updateIfNotActive = this.option.isUpdateIfNotActive();
        PlayerConstants playerConstants = PlayerConstants.getInstance();
        playerConstants.setUsingKeyboard(this.option.isUseKeyboard());
        if (playerConstants.isUsingKeyboard()) {
            KeyConnection.setListener(this.window);
        }
        playerConstants.setUsingMouse(this.option.isUseMouse());
        if (playerConstants.isUsingMouse()) {
            MouseConnection.setListener(this.window);
        } else {
            BufferedImage cursorImage = ImageUtil.newImage(16, 16);
            this.window.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, new Point(), "game cursor"));
        }
        playerConstants.setUsingGamePad(this.option.isUseGamePad());
        if (playerConstants.isUsingGamePad()) {
            GamePadConnection.init();
        }
    }

    public GameWindow getWindow() {
        return this.window;
    }

    public final GameOption getOption() {
        return this.option;
    }

    protected final void gameStart(String ... args) throws IllegalStateException {
        if (this.option == null) {
            throw new IllegalStateException("game option is null");
        }
        if (this.started) {
            throw new IllegalStateException("game is alredy started");
        }
        this.gameTimeManager = new GameTimeManager(this.fps);
        this.loop = new GameLoop(this, this.gameTimeManager, this.updateIfNotActive);
        EventQueue.invokeLater(() -> {
            try {
                this.startUp();
            }
            catch (Throwable ex) {
                GameLog.print(Level.WARNING, "ERROR : " + ex);
                System.exit(1);
            }
            this.window.setVisible(true);
            this.window.createBufferStrategy(2);
            this.graphicsBuffer = this.window.getBufferStrategy();
            this.clippingRectangle = this.window.getInternalBounds();
            this.started = true;
            GameLog.printInfo("gameStart is done.");
            this.loop.start();
        });
        GameLog.printInfoIfUsing(this.getWindow().getTitle() + " is start");
    }

    protected final void gameExit() throws IllegalStateException {
        if (!this.started) {
            throw new IllegalStateException("game is not started");
        }
        if (this.loop != null && this.loop.isStarted()) {
            this.loop.end();
        }
        try {
            this.dispose();
        }
        catch (Throwable ex) {
            GameLog.print(Level.WARNING, "ERROR : " + ex);
            System.exit(1);
        }
        if (PlayerConstants.getInstance().isUsingGamePad()) {
            // empty if block
        }
        LockUtil.deleteLockFile();
        TempFileStorage.getInstance().deleteAll();
        this.window.dispose();
        System.exit(0);
    }

    protected abstract void startUp();

    protected abstract void dispose();

    protected abstract void update(GameTimeManager var1);

    protected abstract void draw(GraphicsContext var1);

    final void repaint() {
        this.g = (Graphics2D)this.graphicsBuffer.getDrawGraphics();
        this.g.setClip(this.clippingRectangle);
        this.g.clearRect(this.clippingRectangle.x, this.clippingRectangle.y, this.clippingRectangle.width, this.clippingRectangle.height);
        this.g.setRenderingHints(this.renderingHints);
        this.draw(new GraphicsContext(this.g));
        this.g.dispose();
        if (this.graphicsBuffer.contentsRestored()) {
            this.repaint();
        }
        this.graphicsBuffer.show();
        if (this.graphicsBuffer.contentsLost()) {
            this.repaint();
        }
    }
}

