/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game;

import java.util.logging.Level;
import java.util.logging.Logger;
import kinugasa.game.GameLog;
import kinugasa.game.GameManager;
import kinugasa.game.GameTimeManager;

public final class GameLoop
implements Runnable {
    private GameManager game;
    private GameTimeManager gtm;
    private Thread thread;
    private volatile boolean exec = false;
    private boolean updateIfNotActive;

    GameLoop(GameManager game, GameTimeManager gtm) {
        this.game = game;
        this.gtm = gtm;
        this.updateIfNotActive = false;
    }

    GameLoop(GameManager game, GameTimeManager gtm, boolean updateIfNotActive) {
        this.game = game;
        this.gtm = gtm;
        this.updateIfNotActive = updateIfNotActive;
    }

    @Override
    public void run() {
        block9: {
            try {
                if (this.updateIfNotActive) {
                    while (this.exec) {
                        long startTime = System.nanoTime();
                        this.game.update(this.gtm);
                        this.game.repaint();
                        this.gtm.sleep(startTime);
                    }
                    break block9;
                }
                while (this.exec) {
                    long startTime;
                    if (this.game.getWindow().isActive()) {
                        startTime = System.nanoTime();
                        this.game.update(this.gtm);
                        this.game.repaint();
                        this.gtm.sleep(startTime);
                        continue;
                    }
                    startTime = System.nanoTime();
                    try {
                        Thread.sleep(1000L / this.gtm.getIdealFPS());
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(GameLoop.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.gtm.sleep(startTime);
                }
            }
            catch (Throwable ex) {
                if (ex instanceof Exception) {
                    ((Exception)ex).printStackTrace();
                }
                GameLog.print(Level.WARNING, ex);
                System.exit(1);
            }
        }
    }

    void end() {
        this.exec = false;
    }

    void start() throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("");
        }
        this.exec = true;
        this.thread = new Thread((Runnable)this, this.game.getOption().getTitle() + ":1");
        this.thread.start();
    }

    boolean isStarted() {
        return this.thread != null;
    }
}

