/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GameLog {
    private static boolean using = false;
    private static String logFilePath;
    private static final SimpleDateFormat DATE_FORMAT;

    private GameLog() {
    }

    protected static void usingLog(String path) {
        using = true;
        logFilePath = path;
    }

    public static String getLogFilePath() {
        return logFilePath;
    }

    public static boolean isUsingLog() {
        return using;
    }

    public static void print(Level lv, String message) {
        Logger.getLogger("global").log(lv, message);
        System.out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " " + message);
    }

    public static void print(Level lv, Throwable t) {
        Logger.getLogger("global").log(lv, t.toString());
        System.out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " " + t);
    }

    public static void printIfUsing(Level lv, String message) {
        if (using) {
            Logger.getLogger("global").log(lv, message);
            System.out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " " + message);
        }
    }

    public static void printIfUsing(Level lv, Throwable t) {
        if (using) {
            Logger.getLogger("global").log(lv, t.toString());
            System.out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " " + t);
        }
    }

    public static void printInfoIfUsing(String string) {
        GameLog.printIfUsing(Level.INFO, string);
    }

    public static void printInfo(String string) {
        GameLog.print(Level.INFO, string);
    }

    static {
        DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
    }
}

