/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import kinugasa.game.GameWindow;

public class AWTGameWindow
extends Frame
implements GameWindow {
    private Rectangle internalBounds;
    private final Canvas canvas = new Canvas();
    private boolean active;

    AWTGameWindow() throws HeadlessException {
        this.add(this.canvas);
        this.canvas.setFocusable(false);
        this.canvas.setEnabled(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                AWTGameWindow.this.active = true;
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                AWTGameWindow.this.active = false;
            }
        });
        this.pack();
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    @Override
    public Cursor getCursor() {
        return super.getCursor();
    }

    @Override
    public void setBackground(Color color) {
        this.canvas.setBackground(color);
    }

    @Override
    public void createBufferStrategy(int i) {
        this.canvas.createBufferStrategy(2);
    }

    @Override
    public BufferStrategy getBufferStrategy() {
        return this.canvas.getBufferStrategy();
    }

    @Override
    public void setVisible(boolean bln) {
        super.setVisible(bln);
        this.canvas.setVisible(true);
        Insets insets = this.getInsets();
        this.internalBounds = new Rectangle();
        this.internalBounds.setSize(this.getSize());
        this.canvas.setSize(this.internalBounds.getSize());
        this.setSize(this.getWidth() + insets.left + insets.right, this.getHeight() + insets.top + insets.bottom);
    }

    @Override
    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    @Override
    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    @Override
    public int getWidth() {
        return this.internalBounds.width;
    }

    @Override
    public int getHeight() {
        return this.internalBounds.height;
    }

    @Override
    public Rectangle getInternalBounds() {
        return (Rectangle)this.internalBounds.clone();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public KeyAdapter[] getKeyListeners() {
        return this.getKeyListeners();
    }
}

