package org.kikaineko.util;

import java.util.Arrays;


public class StringArray {
	private String[] datas;

	private int addLength = 15;// 15

	private int length=0;
	
	public StringArray(){
		datas=new String[addLength];
	}
	public StringArray(int leng){
		datas=new String[leng];
	}

	private StringArray(int addLength,int length){
		this.addLength=addLength;
		this.length=length;
		this.datas=new String[length];
	}
	/**
	 * @return
	 */
	public int length() {
		return length;
	}

	/**
	 * ŏvalindexԂB
	 * 
	 * @param string
	 * @return
	 */
	public int indexOf(String value) {
		return indexOf(value, 0);
	}

	/**
	 * fromIndexȍ~̍ŏvalindexԂB
	 * 
	 * @param string
	 * @param fromIndex
	 * @return
	 */
	public int indexOf(String value, int fromIndex) {
		for (int i = fromIndex; i < length(); i++) {
			if (datas[i].equals(value))
				return i;
		}
		return -1;
	}

	/**
	 * iԖڂ̐lԂB
	 * 
	 * @param i
	 * @return
	 */
	public String get(int i) {
		return datas[i];
	}

	public void deleteThisVal(String value) {
		if (indexOf(value) == -1)
			return;
		String[] temp = new String[length];
		int index = 0;
		int tempLength = 0;
		for (int i = 0; i < length; i++) {
			if (!datas[i].equals(value)) {
				temp[index++] = datas[i];
				tempLength++;
			}
		}
		datas = temp;
		length = tempLength;
	}

	public boolean contains(String i) {
		return indexOf(i) != -1;
	}

	public void add(String i) {
		if(length()==datas.length){
			String[] temp = new String[length+addLength];
			System.arraycopy(datas, 0, temp, 0, datas.length);
			datas=temp;
		}
		datas[length++]=i;
	}

	public StringArray createCopy() {
		StringArray ia=new StringArray(this.addLength,this.length);
		System.arraycopy(this.datas, 0, ia.datas, 0, length);
		return ia;
	}

	public String getLast() {
		return datas[length()-1];
	}
	public String getFirst() {
		return datas[0];
	}
	public boolean isUniq(){
		String first=this.getFirst();
		for(int i=1;i<this.length();i++){
			if(!first.equals(datas[i]))
				return false;
		}
		return true;
	}
	public String[] toArray() {
		String[] temp = new String[length()];
		System.arraycopy(datas, 0, temp, 0, temp.length);
		return temp;
	}
	
	public StringArray dl() {
		String[] temp = toArray();
		Arrays.sort(temp);
		StringArray la2 = new StringArray();
		int index = 0;
		while (index < temp.length - 1) {
			if (temp[index].equals(temp[index + 1])) {
				index++;
				if (!la2.contains(temp[index])) {
					la2.add(temp[index]);
				}
			}
			index++;
		}
		return la2;
	}

	public IntArray dlindexs() {
		StringArray dl=dl();
		IntArray indexs=new IntArray();
		for(int i=0;i<length();i++){
			if(dl.contains(get(i))){
				indexs.add(i);
			}
		}
		return indexs;
	}
}
