package org.kikaineko.mock.runner;

import java.io.File;
import java.lang.reflect.Constructor;

import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.util.ShortConstructorSeeker;

public class InnerClassImplementer extends Implementer {

	public InnerClassImplementer(TargetClass tc) throws Exception {
		super(tc);
	}

	protected String modifierOfKikainekoField() {
		return "private final ";
	}
	protected void head() {
		code.append("return new ");

		writeConstructor();

		code.append("private java.util.Vector ");
		code.append(historyFieldName);
		code.append("=new java.util.Vector();\n\n");
	}

	private void writeConstructor() {
		Constructor cc=null;
		try {
			//Class c = Class.forName(targetClass.getClassName());
			Class c=targetClass.getSuperClass();
			cc = ShortConstructorSeeker.getConst(c);
		} catch (Exception e) {
		}
		
		if (cc == null) {
			//code.append(targetClass.getClassName());
			code.append(targetClass.getSuperClass().getName());
			code.append("() {\n");
		} else {
			Class[] cs = cc.getParameterTypes();
			code.append(targetClass.getSuperClass().getName());
			code.append("(");
			if(cs.length!=0){
				code.append(getParam(cs[0]));
			}
			for(int i=1;i<cs.length;i++){
				code.append(",");
				code.append(getParam(cs[i]));
			}
			code.append(") {\n");
		}
	}
	
	private String getParam(Class c){
		if(c==char.class){
			return "\'1\'";
		}else if(c.isPrimitive()){
			return "1";
		}else if(c==String.class){
			return "\"1\"";
		}
		return "null";
	}

	protected void footer() {
		code.append("};");
	}

	public File getTargetFile() {
		return null;
	}
	
	protected void kikainekoMethodsPart(){
	}
}
