package org.kikaineko.mock.inmemory;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.UndefinedValue;
import org.kikaineko.mock.util.ToStringer;
import org.kikaineko.source.util.LangMgn;

class KikainekoMockerInvocationHandler implements InvocationHandler {
	// special field for in memory
	private TargetMethodForInMemory[] methods;

	private Hashtable undefValsTable;

	private void setMethods(TargetClass targetClass) {
		methods = new TargetMethodForInMemory[targetClass.howManyMethods()];
		for (int i = 0; i < methods.length; i++) {
			TargetMethodForInMemory tmfim = new TargetMethodForInMemory();
			String temp = targetClass.getMethodName(i);

			tmfim.setMethodNameForKikainekomocker(temp);

			String name = temp.substring(0, temp.indexOf("("));
			String classesStr = temp.substring(temp.indexOf("(") + 1, temp
					.length() - 1);
			StringTokenizer st = new StringTokenizer(classesStr);
			Class[] classes = new Class[st.countTokens()];
			for (int j = 0; j < classes.length; j++) {
				classes[j] = getClazz(st.nextToken());
			}
			tmfim.setMethodName(name);
			tmfim.setParams(classes);
			tmfim.setDestory(targetClass.isDestoryMethod(i));
			methods[i] = tmfim;
		}
	}

	private Class getClazz(String name) {
		try {
			Class c = Class.forName(name);
			return c;
		} catch (Exception e) {
		}
		if (LangMgn.isPremit(name)) {
			return LangMgn.getPremitClass(name);
		}
		return null;
	}

	private TargetMethodForInMemory seekingMethodNameForKikainekomocker(
			Method method) {
		for (int i = 0; i < methods.length; i++) {
			TargetMethodForInMemory targetMethod = methods[i];
			if (targetMethod.getMethodName().equals(method.getName())) {
				Class[] classes1 = targetMethod.getParams();
				Class[] classes2 = method.getParameterTypes();
				if (classes1.length == 0 && classes2.length == 0) {
					return targetMethod;
				}
				if (canAssignable(classes1, classes2)) {
					return targetMethod;
				}
			}
		}
		return new TargetMethodForInMemory();
	}

	private boolean canAssignable(Class[] classes1, Class[] classes2) {
		if (classes1.length == classes2.length) {
			for (int j = 0; j < classes1.length; j++) {
				if (!classes1[j].isAssignableFrom(classes2[j])) {
					return false;
				}
			}
			return true;
		}
		return false;
	}

	//

	private java.util.Vector kikainekoHistory = new java.util.Vector();

	public Object invoke(Object proxy, Method method, Object[] args)
			throws Throwable {
		TargetMethodForInMemory targetMethod = seekingMethodNameForKikainekomocker(method);
		if (args == null)
			args = new Object[0];
		String[] params = new String[args.length];
		Class[] paramClasses = method.getParameterTypes(); // paramClassesparams̔z񒷂JVMɂĂ͂

		for (int i = 0; i < params.length; i++) {
			params[i] = ToStringer.getStrick(args[i], paramClasses[i]);
		}

		Object[] cond = kikainekoHistoryAdd(targetMethod
				.getMethodNameForKikainekomocker(), params);

		String res = kikainekoReturn(cond, targetMethod.isDestory());
		if (res.startsWith("org.kikaineko.mock.framework.UndefinedValue(")) {
			// sl̉
			UndefinedValue uv = (UndefinedValue) undefValsTable.get(res);
			System.out.println(res);
			System.out.println(method.getReturnType());
			System.out.println(method.getName());
			if (method.getReturnType().isInterface()) {
				return KikainekoMockerInMemory.createObjectThisTarget(uv,
						method.getReturnType());
			}else{
				try{
					Object o=KikainekoMockerInMemory.createObjectThisTarget(uv,
							uv.getSuperClass());
					return o;
				}catch(Exception e){
					
				}
			}
			Class[] classes = method.getReturnType().getInterfaces();
			for (int i = 0; i < classes.length; i++) {
				if (classes[i].isInterface()) {
					return KikainekoMockerInMemory.createObjectThisTarget(uv,
							classes[i]);
				}
			}
		} else if (res.startsWith("throw new ")) {
			// O̔
			String clazzName = res.replaceAll("throw new ", "");
			throw (Exception) Class.forName(clazzName).newInstance();
		}
		try {
			return org.kikaineko.mock.util.ReturnValue.getObject(res,
					kikainekoUsedConcreteClasses);
		} catch (Exception e) {
			res = "(0)";
			return org.kikaineko.mock.util.ReturnValue.getObject(res);
		}
	}

	public void initialize(TargetClass targetClass) {
		setKikainekoHistories(targetClass);
		setKikainekoRes(targetClass);
		setKikainekoHistoriesTerms(targetClass);
		setKikainekoUsedConcreteClasses(targetClass);
		setMethods(targetClass);
		setUndefValues(targetClass);

		kikainekoHistory = new java.util.Vector();
	}

	private void setUndefValues(TargetClass targetClass) {
		undefValsTable = new Hashtable();
		UndefinedValue[] uvs = targetClass.getUndefValues();
		for (int i = 0; i < uvs.length; i++) {
			undefValsTable.put(ToStringer.getStrick(uvs[i], null), uvs[i]);
		}
	}

	private void setKikainekoHistories(TargetClass targetClass) {
		kikainekoHistories = new String[targetClass.howManyHistories()][];
		for (int i = 0; i < kikainekoHistories.length; i++) {
			kikainekoHistories[i] = targetClass
					.getHistoryAsStringArrayWithoutUndestroyMethod(i);
		}
	}

	private void setKikainekoRes(TargetClass targetClass) {
		kikainekoRes = new String[targetClass.howManyHistories()];
		for (int i = 0; i < kikainekoRes.length; i++) {
			kikainekoRes[i] = targetClass.getValueAtHistory(i);
		}
	}

	private void setKikainekoHistoriesTerms(TargetClass targetClass) {
		Vector vec = new Vector();
		for (int i = 0; i < targetClass.howManyHistories(); i++) {
			Vector tempVec = targetClass
					.getHistoryTermsOnHistoryAtForInMemory(i);
			for (int j = 0; j < tempVec.size(); j++) {
				vec.add(tempVec.get(j));
			}
		}
		kikainekoHistoriesTerms = new String[vec.size()][];
		for (int i = 0; i < kikainekoHistoriesTerms.length; i++) {
			kikainekoHistoriesTerms[i] = (String[]) vec.get(i);
		}
	}

	private void setKikainekoUsedConcreteClasses(TargetClass targetClass) {
		kikainekoUsedConcreteClasses = targetClass.getUsedConcreteClasses();
	}

	private String[][] kikainekoHistories;

	private String[] kikainekoRes;

	private String[][] kikainekoHistoriesTerms;

	private Class[] kikainekoUsedConcreteClasses;

	// ************** kikaineko methods **********************************//

	private Object[] kikainekoHistoryAdd(String name, String[] args) {
		String temp = kikainekoSeekSimularHistoryTerm(name, args);
		kikainekoHistory.add(temp);
		Object[] responce = kikainekoHistory.toArray();
		return responce;
	}

	private String kikainekoSeekSimularHistoryTerm(String name, String[] args) {
		double max = -1;
		int index = -1;
		for (int i = 0; i < kikainekoHistoriesTerms.length; i++) {
			if (kikainekoHistoriesTerms[i][0].startsWith(name)) {
				double flag = kikainekoGetDegreeOfSimilarity(
						kikainekoHistoriesTerms[i], args);
				if (flag > max) {
					max = flag;
					index = i;
				}
			}
		}
		try {
			return kikainekoMakeHistoryTerm(kikainekoHistoriesTerms[index]);
		} catch (Exception e) {
			return "";
		}
	}

	private double kikainekoGetDegreeOfSimilarity(String[] expecteds,
			String[] actuals) {
		if ((expecteds.length - 1) != actuals.length) {
			return 0;
		}
		if (actuals.length == 0) {
			return 1;
		}
		double count = 0;
		for (int i = 1; i < expecteds.length; i++) {
			if (expecteds[i].equals(actuals[i - 1])) {
				count += 1.0;
			}
		}
		return count / actuals.length;
	}

	private String kikainekoMakeHistoryTerm(String[] args) {
		String temp = args[0];
		if (args.length != 1) {
			temp += "(";
			for (int i = 1; i < args.length; i++) {
				temp += args[i] + " ";
			}
			temp += ")";
		}
		temp += ";";
		return temp;
	}

	private int kikainekoIndexOfHis(Object[] args) {
		for (int i = 0; i < kikainekoHistories.length; i++) {
			if (kikainekoEqulaStringArrays(kikainekoHistories[i], args))
				return i;
		}
		return kikainekoSeekingHistory(args);
	}

	private String kikainekoReturn(Object[] arg, boolean isDestroy) {
		String res = "";
		int index = kikainekoIndexOfHis(arg);
		if (index == -1) {
			res = "(0)";
		} else {
			res = kikainekoRes[index];
		}
		if (!isDestroy)
			kikainekoHistory.remove(kikainekoHistory.size() - 1);
		return res;
	}

	private boolean kikainekoEqulaStringArrays(String[] arg1, Object[] arg2) {
		if (arg1.length != arg2.length)
			return false;
		for (int i = 0; i < arg1.length; i++) {
			if (!arg1[i].equals(arg2[i])) {
				return false;
			}
		}
		return true;
	}

	private int kikainekoSeekingHistory(Object[] args) {
		java.util.Vector indexs = kikainekoGetEndsWithAndSameLengthHistories(args);
		Object[] tempArgs = null;
		if (indexs.size() > 0) {
			tempArgs = (Object[]) args.clone();
		}
		for (int i = 0; i < indexs.size(); i++) {
			String[] tempHistory = kikainekoHistories[((Integer) indexs.get(i))
					.intValue()];
			if (kikainekoSameHistoryTermAndChangeHistory(tempArgs,
					(String[]) tempHistory.clone()))
				return ((Integer) indexs.get(i)).intValue();
		}
		indexs = kikainekoGetEndsWithAndShortHistories(args);
		for (int i = args.length - 1; i >= 0; i--) {
			for (int j = 0; j < indexs.size(); j++) {
				String[] tempHistory = kikainekoHistories[((Integer) indexs
						.get(j)).intValue()];
				if (i == tempHistory.length) {
					if (kikainekoBackwardMatchAndChangeHistory(tempHistory))
						return ((Integer) indexs.get(j)).intValue();
				}
			}
		}
		return -1;
	}

	private boolean kikainekoBackwardMatchAndChangeHistory(String[] tempHistory) {
		java.util.Vector temp = (java.util.Vector) kikainekoHistory.clone();
		int delta = temp.size() - tempHistory.length;
		for (int i = 0; i < delta; i++) {
			temp.remove(0);
		}
		if (kikainekoEqulaStringArrays(tempHistory, temp.toArray())) {
			kikainekoHistory = temp;
			return true;
		}
		return false;
	}

	private java.util.Vector kikainekoGetEndsWithAndShortHistories(Object[] args) {
		java.util.Vector temp = new java.util.Vector();
		String lastMethod = (String) args[args.length - 1];
		for (int i = 0; i < kikainekoHistories.length; i++) {
			String[] tempHistory = kikainekoHistories[i];
			if (lastMethod.equals(tempHistory[tempHistory.length - 1])) {
				if (tempHistory.length < args.length) {
					temp.add(new Integer(i));
				}
			}
		}
		return temp;
	}

	private java.util.Vector kikainekoGetEndsWithAndSameLengthHistories(
			Object[] args) {
		java.util.Vector temp = new java.util.Vector();
		String lastMethod = (String) args[args.length - 1];
		for (int i = 0; i < kikainekoHistories.length; i++) {
			String[] tempHistory = kikainekoHistories[i];
			if (lastMethod.equals(tempHistory[tempHistory.length - 1])) {
				if (tempHistory.length == args.length) {
					temp.add(new Integer(i));
				}
			}
		}
		return temp;
	}

	private boolean kikainekoSameHistoryTermAndChangeHistory(Object[] temp1,
			String[] args2) {
		String[] temp2 = (String[]) args2.clone();
		java.util.Arrays.sort(temp1);
		java.util.Arrays.sort(temp2);
		for (int i = 0; i < temp1.length; i++) {
			if (!temp1[i].equals(temp2[i]))
				return false;
		}
		java.util.Vector temp = new java.util.Vector();
		for (int i = 0; i < args2.length; i++) {
			temp.add(args2[i]);
		}
		kikainekoHistory = temp;
		return true;
	}

}
