package org.kikaineko.mock.framework.junit4;

import java.util.Vector;

import org.kikaineko.mock.framework.TestClass;
import org.kikaineko.mock.framework.TestMethod;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

public class TestClassForJunit4 extends TestClass {
	private TestMethod beforeClass;

	private TestMethod afterClass;

	public TestClassForJunit4(String pack, String name) {
		super(pack, name);
	}
	
	public void addTestMethod(TokenArray ta) {
		int index=ta.indexOfVal("@", "Test", "(");
		int index2=ta.indexOfVal("expected","=");
		if((index+3)==index2){
			TokenArray excepTa=getException(ta,index2+2);
			Token[] tokens=new Token[2];
			tokens[0]=new Token(TokenKind.Word,"try");
			tokens[1]=new Token(TokenKind.BlockOpen,"{");
			index=ta.indexOfVal("{",index);
			ta.insertIntoTokens(tokens, index+1);
			
			Vector vec=new Vector();
			vec.add(new Token(TokenKind.Word,"fail"));
			vec.add(new Token(TokenKind.OpenKakko,"("));
			vec.add(new Token(TokenKind.CloseKakko,")"));
			vec.add(new Token(TokenKind.SemiKoron,";"));
			vec.add(new Token(TokenKind.BlockClose,"}"));
			vec.add(new Token(TokenKind.Word,"catch"));
			vec.add(new Token(TokenKind.OpenKakko,"("));
			
			for(int j=0;j<excepTa.length();j++){
				vec.add(excepTa.get(j));
			}
			
			vec.add(new Token(TokenKind.Word,"e"));
			vec.add(new Token(TokenKind.CloseKakko,")"));
			vec.add(new Token(TokenKind.BlockOpen,"{"));
			vec.add(new Token(TokenKind.BlockClose,"}"));
			tokens=new Token[vec.size()];
			for(int j=0;j<tokens.length;j++){
				tokens[j]=(Token)vec.get(j);
			}
			index=ta.length()-1;
			ta.insertIntoTokens(tokens, index);
		}
		super.addTestMethod(ta);
	}
	private TokenArray getException(TokenArray ta,int from){
		int end=ta.indexOfVal(".","class",from);
		return ta.subArray(from, end);
	}

	public void setBeforeClass(TokenArray ta) {
		beforeClass = new TestMethod(ta);
	}

	public void setAfterClass(TokenArray ta) {
		afterClass = new TestMethod(ta);
	}

	public TestMethod getAfterClass() {
		return afterClass;
	}

	public TestMethod getBeforeClass() {
		return beforeClass;
	}
}
