package org.kikaineko.mock.framework;

import java.util.Vector;

import org.kikaineko.util.IntArray;

class TargetHistory {
	private static Vector pool = new Vector();

	private int symbol;

	private IntArray history;

	private TargetHistory() {
		history = new IntArray();
	}

	public IntArray toIntArray() {
		return history.createCopy();
	}

	public static TargetHistory makeCurrentHistory() {
		TargetHistory th = new TargetHistory();
		return th;
	}
	
	protected void setHistory(IntArray ia){
		history=ia;
	}

	/**
	 * ݂̃qXg[̃Rs[v[ARs[
	 * 
	 * @return
	 */
	public int getSymbolOfFreezedCurrentHistoryAndPoolIt() {
		TargetHistory th = new TargetHistory();
		th.history = history.createCopy();
		int index = pool.indexOf(th);
		if (index != -1) {
			th = null;
			return ((TargetHistory) pool.get(index)).symbol;
		}
		th.symbol = pool.size();
		pool.add(th);
		return th.symbol;
	}

	public static TargetHistory getTargetHistoryBySymbol(int index) {
		return (TargetHistory) pool.get(index);
	}

	public void add(String methodName, String[] arg) {
		history.add(TargetHistoryTerm.getSymbol(methodName, arg));
	}

	public int length() {
		return history.length();
	}

	public int getHistoryTermSymbolAt(int i) {
		return history.get(i);
	}

	public String toString() {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < history.length(); i++) {
			int symbol = history.get(i);
			TargetHistoryTerm tht = TargetHistoryTerm.getBySymbol(symbol);
			sb.append(tht.getMethodName());
			sb.append(tht.getArg());
			sb.append(";");
		}
		return sb.toString();
	}

	public String toStringWithoutUndestroyMethod() {
		if (history.length() == 0) {
			return "";
		}

		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < history.length() - 1; i++) {
			int symbol = history.get(i);
			TargetHistoryTerm tht = TargetHistoryTerm.getBySymbol(symbol);
			if (tht.isDestroy()) {
				sb.append(tht.getMethodName());
				sb.append(tht.getArg());
				sb.append(";");
			}
		}

		int symbol = history.get(history.length() - 1);
		TargetHistoryTerm tht = TargetHistoryTerm.getBySymbol(symbol);
		sb.append(tht.getMethodName());
		sb.append(tht.getArg());
		sb.append(";");

		return sb.toString();
	}

	public String[] toArrayWithoutUndestroyMethod() {
		Vector temps = new Vector();

		for (int i = 0; i < history.length()-1; i++) {
			int symbol = history.get(i);
			TargetHistoryTerm tht = TargetHistoryTerm.getBySymbol(symbol);
			if (tht.isDestroy()) {
				StringBuffer sb = new StringBuffer();
				sb.append(tht.getMethodName());
				sb.append(tht.getArg());
				sb.append(";");
				temps.add(sb.toString());
			}
		}
		int symbol = history.get(history.length() - 1);
		TargetHistoryTerm tht = TargetHistoryTerm.getBySymbol(symbol);
		StringBuffer sb = new StringBuffer();
		sb.append(tht.getMethodName());
		sb.append(tht.getArg());
		sb.append(";");
		temps.add(sb.toString());
		
		String[] ss=new String[temps.size()];
		for(int i=0;i<ss.length;i++){
			ss[i]=(String)temps.get(i);
		}
		return ss;
	}

	public String toStringArrayExpressionWithoutUndestroyMethod() {
		if (history.length() == 0) {
			return "{}";
		}

		StringBuffer sb = new StringBuffer();
		sb.append("{");
		for (int i = 0; i < history.length() - 1; i++) {
			int symbol = history.get(i);
			TargetHistoryTerm tht = TargetHistoryTerm.getBySymbol(symbol);
			if (tht.isDestroy()) {
				sb.append("\"");
				sb.append(tht.getMethodName());
				sb.append(tht.getArg());
				
				sb.append(";");
				sb.append("\",");
			}
		}

		int symbol = history.get(history.length() - 1);
		TargetHistoryTerm tht = TargetHistoryTerm.getBySymbol(symbol);
		sb.append("\"");
		sb.append(tht.getMethodName());
		sb.append(tht.getArg());
		sb.append(";");
		sb.append("\"}");

		return sb.toString();
	}

	public int getHistorySymbol() {
		return symbol;
	}

	public boolean equals(Object other) {
		if (!other.getClass().equals(this.getClass())) {
			return false;
		}
		TargetHistory th = (TargetHistory) other;
		IntArray otherHistory = th.history;
		if (otherHistory.length() != this.history.length()) {
			return false;
		}

		for (int i = 0; i < otherHistory.length(); i++) {
			if (otherHistory.get(i) != this.history.get(i)) {
				return false;
			}
		}

		return true;
	}

	public static int count() {
		return pool.size();
	}

	protected static void initialize() {
		pool = new Vector();
	}

	public String lastCallingMethod() {
		return lastTargetHistoryTerm().getMethodName();
	}

	public String lastCallingArg() {
		return lastTargetHistoryTerm().getArg();
	}

	private TargetHistoryTerm lastTargetHistoryTerm() {
		return TargetHistoryTerm.getBySymbol(lastCallingTermAsSymbol());
	}

	public String lastCallingTermAsString() {
		return lastCallingMethod() + lastCallingArg() + ";";
	}

	public int lastCallingTermAsSymbol() {
		return history.getLast();
	}

	TargetHistoryTerm getTargetHistoryTermAt(int index) {
		int symbol = history.get(index);
		return TargetHistoryTerm.getBySymbol(symbol);
	}

	public String[] getHistoryTerms() {
		String[] ss = new String[history.length()];
		for (int i = 0; i < history.length(); i++) {
			int symbol = history.get(i);
			TargetHistoryTerm tht = TargetHistoryTerm.getBySymbol(symbol);
			ss[i] = tht.toStringAsStringArray();
		}
		return ss;
	}

	public Vector getHistoryTermsForInMemory() {
		Vector vec = new Vector();
		Vector terms=new Vector();
		for (int i = 0; i < history.length(); i++) {
			Integer symbol = new Integer(history.get(i));
			if (!vec.contains(symbol)) {
				vec.add(symbol);
				TargetHistoryTerm tht = TargetHistoryTerm.getBySymbol(symbol.intValue());
				terms.add(tht.toStringArray());
			}
		}
		return terms;
	}
}
