package org.kikaineko.mock.framework;

import org.kikaineko.util.IntArray;

public class StaticMethodFilter implements Filter {

	public TargetClass execute(TargetClass tc) {
		for(int historyIndex=0;historyIndex<TargetHistory.count();historyIndex++){
			TargetHistory his=TargetHistory.getTargetHistoryBySymbol(historyIndex);
			String name=his.lastCallingMethod();
			if(tc.isStaticMethod(name)){
				doit(tc,his);
			}
		}
		return tc;
	}
	
	private void doit(TargetClass tc,TargetHistory his){
		IntArray ia=his.toIntArray();
		IntArray notStaticSymbols=new IntArray();
		for(int i=0;i<ia.length();i++){
			int index=ia.get(i);
			TargetHistoryTerm tht = TargetHistoryTerm.getBySymbol(index);
			String name=tht.getMethodName();
			if(!tc.isStaticMethod(name)){
				notStaticSymbols.add(index);
			}
		}
		for(int i=0;i<notStaticSymbols.length();i++){
			ia.deleteThisVal(notStaticSymbols.get(i));
		}
		his.setHistory(ia);
	}

}
