package org.kikaineko.mock.analysis.junit4;

import java.lang.reflect.Method;

import org.kikaineko.mock.analysis.ClassNameResolver;
import org.kikaineko.mock.framework.MethodInTestCase;
import org.kikaineko.mock.framework.TestClass;
import org.kikaineko.source.util.LangMgn;

/**
 * ϒzl\bh
 * @author masayuki
 *
 */
public class MethodSeacherForJUnit4VariableArguments {
	public static Object[] searchMethodInTestCase(String name, Object[] vals,
			TestClass tc, ClassNameResolver classNameResolver) {
		MethodInTestCase m;
		for (int i = 0; i < tc.howManyMethodsInTestCase(); i++) {
			m = tc.getMethodInTestCase(i);
			if (name.equals(m.getName())) {
				String[] typeByStrings = m.getArgsClass();
				Class[] types = new Class[typeByStrings.length];
				for (int j = 0; j < types.length; j++) {
					types[j] = classNameResolver.getClazz(typeByStrings[j]);
				}
				if (types == null || types.length == 0)
					break;
				// ŌオzłȂĂ͂Ȃ
				if (types[types.length - 1].isArray()) {
					Object[] newVals = getNewVals(vals, types);
					if (newVals == null)
						break;
					Object[] temps = getArray(vals, (types.length - 1), LangMgn
							.unitTypeInArray(types[types.length - 1]));
					if (temps == null)
						break;

					newVals[newVals.length - 1] = temps;

					return new Object[] { m, newVals, types };
				}
			}
		}
		return null;
	}

	/**
	 * ϒzڗČ
	 * 
	 * @param clazz
	 * @param name
	 * @param vals
	 * @param cs
	 * @return
	 */
	public static Object[] search(Class clazz, String name, Object[] vals,
			Class[] cs) {
		Method[] ms = clazz.getMethods();
		for (int i = 0; i < ms.length; i++) {
			if (ms[i].getName().equals(name)) {
				Class[] types = ms[i].getParameterTypes();
				if (types == null || types.length == 0)
					break;
				// ŌオzłȂĂ͂Ȃ
				if (types[types.length - 1].isArray()) {
					Object[] newVals = getNewVals(vals, types);
					if (newVals == null)
						break;
					Object[] temps = getArray(vals, (types.length - 1), LangMgn
							.unitTypeInArray(types[types.length - 1]));
					if (temps == null)
						break;

					newVals[newVals.length - 1] = temps;

					return new Object[] { ms[i], newVals, types };
				}
			}
		}
		return null;
	}

	private static Object[] getArray(Object[] vals, int start, Class c) {
		if (vals == null)
			return new Object[0];
		Object[] temps = new Object[vals.length - start];
		for (int j = start; j < vals.length; j++) {
			if (vals[j] == null) {
				temps[j - start] = null;
			} else if (c.isAssignableFrom(vals[j].getClass())) {
				temps[j - start] = vals[j];
			} else {
				return null;
			}
		}
		return temps;
	}

	/**
	 * Ō̔zȊOlߑւȂ
	 * 
	 * @param vals
	 * @param types
	 * @return
	 */
	private static Object[] getNewVals(Object[] vals, Class[] types) {
		Object[] newVals = new Object[types.length];
		for (int j = 0; j < newVals.length - 1; j++) {
			if (types[j].isAssignableFrom(vals[j].getClass())) {
				newVals[j] = vals[j];
			} else if (AutoBoxingHelper.canAutoBoxing(types[j], vals[j]
					.getClass())) {
				newVals[j] = vals[j];
			} else {
				return null;
			}
		}
		return newVals;
	}
}
