package org.kikaineko.mock.analysis.junit4;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Stack;

import org.kikaineko.mock.analysis.innersi.SharedFields;
import org.kikaineko.mock.analysis.innersi.Variable;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

public class ForBlockForJUnit4 {
	private static int uniqSeq = 0;

	/**
	 * for ( int i : v ) { .<br> .<br>
	 * for ( int xxx=0;xxx<v.length;xxx++) { int i=v.get(xxx);
	 * 
	 */
	public static void run(SharedFields sf) throws Exception {
		int deleteFrom = sf.index - 1;// sf.index(̂߁Afor܂Ŗ߂
		int deleteTo = sf.tokenArray.indexOfVal("{", sf.index) + 1;
		String colectionName = findColection(sf);
		String valType = sf.tokenArray.getVal(sf.index + 1);
		String valName = sf.tokenArray.getVal(sf.index + 2);
		Class colType = sf.vt.getType(colectionName);
		boolean iteratorFlag = haveIterator(colType);

		String indexerName = getUniqIndexerName(sf);
		
		Token[] firstPart = firstPartExp(indexerName,colectionName,iteratorFlag);
		Token[] sizeTokens = sizeTokenExp(colType, indexerName, colectionName,
				iteratorFlag);
		Token[] increTokens =increTokensExp(indexerName,iteratorFlag);
		Token[] nextGetTokens = nextGetTokensExp(colType,valType,valName,colectionName, indexerName,iteratorFlag);

		int calcuratedLength = firstPart.length + sizeTokens.length +increTokens.length+nextGetTokens.length;
		Token[] tokens = new Token[calcuratedLength];
		int counter = 0;
		for (int i = 0; i < firstPart.length; i++) {
			tokens[counter++] = firstPart[i];
		}
		for (int i = 0; i < sizeTokens.length; i++) {
			tokens[counter++] = sizeTokens[i];
		}
		for (int i = 0; i < increTokens.length; i++) {
			tokens[counter++] = increTokens[i];
		}
		for (int i = 0; i < nextGetTokens.length; i++) {
			tokens[counter++] = nextGetTokens[i];
		}

		TokenArray tempTokenArray = sf.tokenArray.takeSubArray(deleteFrom,
				deleteTo);
		sf.tokenArray.insertIntoTokens(tokens, deleteFrom);

		int zoubun = tokens.length - tempTokenArray.length();
		normalize(sf.loopEndIndexStack, zoubun, deleteFrom);
		normalize(sf.loopStartIndexStack, zoubun, deleteFrom);
		normalize(sf.forConditionIndexStack, zoubun, deleteFrom);
		normalize(sf.forIncrementStatementIndexStack, zoubun, deleteFrom);
		
		if(iteratorFlag){
			sf.index--;
			Variable.run(sf,Iterator.class);
			sf.index++;
		}
	}

	private static Token[] increTokensExp(String indexerName,boolean iteratorFlag) {
		int counter = 0;
		if(iteratorFlag){
			Token[] tokens = new Token[3];
			tokens[counter++] = new Token(TokenKind.SemiKoron, ";");
			tokens[counter++] = new Token(TokenKind.CloseKakko, ")");
			tokens[counter++] = new Token(TokenKind.BlockOpen, "{");
			return tokens;
		}
		Token[] tokens = new Token[5];
		tokens[counter++] = new Token(TokenKind.SemiKoron, ";");
		tokens[counter++] = new Token(TokenKind.Word, indexerName);
		tokens[counter++] = new Token(TokenKind.PP, "++");
		tokens[counter++] = new Token(TokenKind.CloseKakko, ")");
		tokens[counter++] = new Token(TokenKind.BlockOpen, "{");

		return tokens;
	}

	private static Token[] firstPartExp(String indexerName, String colectionName,boolean iteratorFlag) {
		int counter = 0;
		if(iteratorFlag){
			Token[] tokens = new Token[11];
			tokens[counter++] = new Token(TokenKind.Word, indexerName);
			tokens[counter++] = new Token(TokenKind.Eq, "=");
			tokens[counter++] = new Token(TokenKind.Word, colectionName);
			tokens[counter++] = new Token(TokenKind.Piriod, ".");
			tokens[counter++] = new Token(TokenKind.Word, "iterator");
			tokens[counter++] = new Token(TokenKind.OpenKakko, "(");
			tokens[counter++] = new Token(TokenKind.CloseKakko, ")");
			tokens[counter++] = new Token(TokenKind.SemiKoron, ";");
			tokens[counter++] = new Token(TokenKind.Word, "for");
			tokens[counter++] = new Token(TokenKind.OpenKakko, "(");
			tokens[counter++] = new Token(TokenKind.SemiKoron, ";");
			return tokens;
		}
		Token[] tokens = new Token[7];
		tokens[counter++] = new Token(TokenKind.Word, "for");
		tokens[counter++] = new Token(TokenKind.OpenKakko, "(");
		tokens[counter++] = new Token(TokenKind.Word, "int");
		tokens[counter++] = new Token(TokenKind.Word, indexerName);
		tokens[counter++] = new Token(TokenKind.Eq, "=");
		tokens[counter++] = new Token(TokenKind.Number, "0");
		tokens[counter++] = new Token(TokenKind.SemiKoron, ";");
		return tokens;
	}

	private static Token[] sizeTokenExp(Class colType, String indexerName,
			String colectionName, boolean iteratorFlag) {
		int counter = 0;
		if (colType.isArray()) {
			Token[] ts = new Token[5];
			ts[counter++] = new Token(TokenKind.Word, indexerName);
			ts[counter++] = new Token(TokenKind.CondLT, "<");
			ts[counter++] = new Token(TokenKind.Word, colectionName);
			ts[counter++] = new Token(TokenKind.Piriod, ".");
			ts[counter++] = new Token(TokenKind.Word, "length");
			return ts;
		}else if(iteratorFlag){
			Token[] ts = new Token[5];
			ts[counter++] = new Token(TokenKind.Word, indexerName);
			ts[counter++] = new Token(TokenKind.Piriod, ".");
			ts[counter++] = new Token(TokenKind.Word, "hasNext");
			ts[counter++] = new Token(TokenKind.OpenKakko, "(");
			ts[counter++] = new Token(TokenKind.CloseKakko, ")");
			return ts;
		}
		Token[] ts = new Token[7];
		ts[counter++] = new Token(TokenKind.Word, indexerName);
		ts[counter++] = new Token(TokenKind.CondLT, "<");
		ts[counter++] = new Token(TokenKind.Word, colectionName);
		ts[counter++] = new Token(TokenKind.Piriod, ".");
		ts[counter++] = new Token(TokenKind.Word, "size");
		ts[counter++] = new Token(TokenKind.OpenKakko, "(");
		ts[counter++] = new Token(TokenKind.CloseKakko, ")");
		return ts;
	}

	private static boolean haveIterator(Class colType) {
		Method[] ms = colType.getMethods();
		for (int i = 0; i < ms.length; i++) {
			if (ms[i].getName().equals("iterator")
					&& ms[i].getReturnType() == Iterator.class) {
				return true;
			}
		}
		return false;
	}

	private static void normalize(Stack stack, int zoubun, int from) {
		for (int i = 0; i < stack.size(); i++) {
			int index = ((Integer) stack.get(i)).intValue();
			if (index > from)
				stack.set(i, new Integer(index + zoubun));
		}
	}

	private static Token[] nextGetTokensExp(Class colType, String valType,String valName,String colectionName,String indexerName,boolean iteratorFlag) {
		int counter = 0;
		if (colType.isArray()) {
			Token[] tokens = new Token[8];
			tokens[counter++] = new Token(TokenKind.Word, valType);
			tokens[counter++] = new Token(TokenKind.Word, valName);
			tokens[counter++] = new Token(TokenKind.Eq, "=");
			tokens[counter++] = new Token(TokenKind.Word, colectionName);
			tokens[counter++] = new Token(TokenKind.ArrayOpen, "[");
			tokens[counter++] = new Token(TokenKind.Word, indexerName);
			tokens[counter++] = new Token(TokenKind.ArrayClose, "]");
			tokens[counter++] = new Token(TokenKind.SemiKoron, ";");
			return tokens;
		}else if(iteratorFlag){
			Token[] tokens = new Token[9];
			tokens[counter++] = new Token(TokenKind.Word, valType);
			tokens[counter++] = new Token(TokenKind.Word, valName);
			tokens[counter++] = new Token(TokenKind.Eq, "=");
			tokens[counter++] = new Token(TokenKind.Word, indexerName);
			tokens[counter++] = new Token(TokenKind.Piriod, ".");
			tokens[counter++] = new Token(TokenKind.Word, "next");
			tokens[counter++] = new Token(TokenKind.OpenKakko, "(");
			tokens[counter++] = new Token(TokenKind.CloseKakko, ")");
			tokens[counter++] = new Token(TokenKind.SemiKoron, ";");
			return tokens;
		}
		Token[] tokens = new Token[10];
		tokens[counter++] = new Token(TokenKind.Word, valType);
		tokens[counter++] = new Token(TokenKind.Word, valName);
		tokens[counter++] = new Token(TokenKind.Eq, "=");
		tokens[counter++] = new Token(TokenKind.Word, colectionName);
		tokens[counter++] = new Token(TokenKind.Piriod, ".");
		tokens[counter++] = new Token(TokenKind.Word, "get");
		tokens[counter++] = new Token(TokenKind.OpenKakko, "(");
		tokens[counter++] = new Token(TokenKind.Word, indexerName);
		tokens[counter++] = new Token(TokenKind.CloseKakko, ")");
		tokens[counter++] = new Token(TokenKind.SemiKoron, ";");
		return tokens;
	}

	private static String getUniqIndexerName(SharedFields sf) {
		String name = getIndexerName(sf);
		while (sf.tokenArray.indexOfVal(name) != -1) {
			name = getIndexerName(sf);
		}
		return name;
	}

	private static String getIndexerName(SharedFields sf) {
		return "kikainekoInnerIndexer__No__" + (uniqSeq++);
	}

	private static String findColection(SharedFields sf) {
		int i = sf.index;
		while (sf.tokenArray.getKind(i) != TokenKind.Koron) {
			i++;
		}
		return sf.tokenArray.getVal(i + 1);
	}
}
