package org.kikaineko.mock.analysis.junit4;

public class AutoBoxingHelper {
	public static boolean canAutoBoxing(Class c1, Class c2){
		if(canSimpleAutoBoxing(c1,c2))
			return true;
		return canComplexAutoBoxing(c1, c2);
	}
	private static boolean canSimpleAutoBoxing(Class c1, Class c2) {
		if (autoBoxingSimpleCheck(c1, c2, Integer.class, int.class))
			return true;
		else if (autoBoxingSimpleCheck(c1, c2, Long.class, long.class))
			return true;
		else if (autoBoxingSimpleCheck(c1, c2, Float.class, float.class))
			return true;
		else if (autoBoxingSimpleCheck(c1, c2, Double.class, double.class))
			return true;
		else if (autoBoxingSimpleCheck(c1, c2, Boolean.class, boolean.class))
			return true;
		else if (autoBoxingSimpleCheck(c1, c2, Character.class, char.class))
			return true;
		else if (autoBoxingSimpleCheck(c1, c2, Byte.class, byte.class))
			return true;
		else if (autoBoxingSimpleCheck(c1, c2, Short.class, short.class))
			return true;
		return false;
	}

	private static boolean autoBoxingSimpleCheck(Class c1, Class c2,
			Class wrapper, Class primit) {
		return (c1 == wrapper && c2 == primit)
				|| (c1 == primit && c2 == wrapper);
	}
	
	private static boolean canComplexAutoBoxing(Class c1, Class c2) {

		if (autoBoxingComplexCheck(c1, c2, Integer.class, int.class))
			return true;
		else if (autoBoxingComplexCheck(c1, c2, Long.class, long.class))
			return true;
		else if (autoBoxingComplexCheck(c1, c2, Float.class, float.class))
			return true;
		else if (autoBoxingComplexCheck(c1, c2, Double.class, double.class))
			return true;
		else if (autoBoxingComplexCheck(c1, c2, Boolean.class, boolean.class))
			return true;
		else if (autoBoxingComplexCheck(c1, c2, Character.class, char.class))
			return true;
		else if (autoBoxingComplexCheck(c1, c2, Byte.class, byte.class))
			return true;
		else if (autoBoxingComplexCheck(c1, c2, Short.class, short.class))
			return true;
		return false;
	}

	private static boolean autoBoxingComplexCheck(Class c1, Class c2,
			Class wrapper, Class primit) {
		return (c1.isAssignableFrom(wrapper) && c2 == primit)
				|| (c1 == primit && c2.isAssignableFrom(wrapper));
	}
}
