package org.kikaineko.mock.analysis.innersi;

import org.kikaineko.mock.analysis.ClassNameResolver;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

public class Variable {
	public static void run(SharedFields sf, Class type) throws Exception {
		TokenArray tokenArray = sf.tokenArray;

		Token t = tokenArray.getToken(sf.index++);
		if (t.getKind() == TokenKind.ArrayOpen) {
			array(sf, type);
		} else {
			String name = t.getVal();
			if(name.equals("<")){
				IgnoreGenerics.run(sf);
				name=sf.tokenArray.getVal(sf.index++);
			}
			Token t2 = tokenArray.getToken(sf.index++);

			if (t2.getKind() == TokenKind.ArrayOpen) {
				array2(sf, type, name);
			} else {
				sf.vt.addVariable(name, type, sf.currentLevel);
				if (t2.getVal().equals("=")) {
					Eq.run(sf, type, name);
				} else if (t2.getVal().equals(";")) {
					if (type.isPrimitive()) {
						if (type == char.class) {
							sf.vt.setValAndLevel(name, Character.valueOf((char)0),
									sf.currentLevel);
						} else {
							sf.vt.setValAndLevel(name, new Integer(0),
									sf.currentLevel);
						}
					} else {
						sf.vt.setValAndLevel(name, null, sf.currentLevel);
					}
				}
			}
		}

		if (tokenArray.getVal(sf.index).equals(",")) {
			sf.index++;
			Variable.run(sf, type);
		}
	}

	private static void array(SharedFields sf, Class type) throws Exception {
		TokenArray tokenArray = sf.tokenArray;
		sf.index++;// ]i܂
		String name = tokenArray.getVal(sf.index++);
		if (name.equals("[")) {
			// 
			type = multiArrayType(sf, type);
			name = tokenArray.getVal(sf.index++);
			sf.vt.addVariable(name, ClassNameResolver.getArrayClass(type),
					sf.currentLevel);
		} else {
			sf.vt.addVariable(name, ClassNameResolver.getArrayClass(type),
					sf.currentLevel);
		}
		String s = tokenArray.getVal(sf.index++);
		if (s.equals("=")) {
			SetVariableArray.run(sf, name);
		}
	}

	private static Class multiArrayType(SharedFields sf, Class type) {
		TokenArray tokenArray = sf.tokenArray;
		while (tokenArray.getKind(sf.index) != TokenKind.Word) {
			if (tokenArray.getKind(sf.index) == TokenKind.ArrayClose) {
				type = ClassNameResolver.getArrayClass(type);
			}
			sf.index++;
		}
		return type;
	}

	private static void array2(SharedFields sf, Class type, String name)
			throws Exception {
		TokenArray tokenArray = sf.tokenArray;
		sf.index++;// ]i܂
		String s = tokenArray.getVal(sf.index);
		if (s.equals("[")) {
			sf.index++;// [
			type = multiArrayType(sf, type);
			sf.index--;// =
		}
		sf.vt.addVariable(name, ClassNameResolver.getArrayClass(type),
				sf.currentLevel);
		s = tokenArray.getVal(sf.index++);
		if (s.equals("=")) {
			SetVariableArray.run(sf, name);
		}
	}
}
