package org.kikaineko.mock.analysis.innersi;

import org.kikaineko.mock.analysis.exception.CannotUseUndefValueException;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.UndefinedValue;
import org.kikaineko.mock.util.ToStringer;

public class TargetInvokingForUndefinedValue {

	public static void run(SharedFields sf, UndefinedValue undefV,
			TargetClass tempTarget) throws Exception {
		doTargetInvokingForUndefinedValue(sf, undefV, tempTarget);
		sf.valueStack.push(undefV);
		// usedConcreteClassesUndefinedValueĂ܂̂ŁAQȂ̒lĂ
		sf.typeStack.push(void.class);
	}

	private static String doTargetInvokingForUndefinedValue(SharedFields sf,
			UndefinedValue undefV, TargetClass tempTarget) throws Exception {
		String name = TargetInvoke.run(sf, tempTarget);

		if (name == null)
			throw new CannotUseUndefValueException();

		String s = ToStringer.getStrick(undefV, null);
		undefV.setMethodNameGeneratingThisUndefValue(name);
		undefV.setActualValueGenaratedByTargetClass(s);

		int currentHistorySymbol = tempTarget.expectValueAtCurrentHistory(s);
		undefV
				.setTargetClassHistorySymbolGeneratingThisUndefValue(currentHistorySymbol);

		tempTarget.overWriteMethodReType(name, undefV.getSuperName());
		
		return name;
	}

	public static void staticRun(SharedFields sf, UndefinedValue undefV, TargetClass tempTarget) throws Exception {
		String name=doTargetInvokingForUndefinedValue(sf, undefV, tempTarget);
		sf.valueStack.push(undefV);
		// usedConcreteClassesUndefinedValueĂ܂̂ŁAQȂ̒lĂ
		sf.typeStack.push(void.class);
		
		sf.target.mustStaticMethod(name);
	}

}
