package org.kikaineko.mock.analysis.innersi;

import java.util.Stack;

import org.kikaineko.mock.analysis.SmallInterpreterSupportor;
import org.kikaineko.mock.analysis.VariableTable;
import org.kikaineko.mock.analysis.exception.CannotUseThisTokenException;
import org.kikaineko.mock.analysis.exception.CannotUsingDoubleInstancesException;
import org.kikaineko.mock.analysis.exception.MaybeCannotCompileException;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

public class Statement {
	public static void run(SharedFields sf, String s) throws Exception {
		
		VariableTable vt = sf.vt;
		Stack valueStack = sf.valueStack;
		String targetName = sf.targetName;
		
		TokenArray tokenArray = sf.tokenArray;
		if (tokenArray.getKind(sf.index) == TokenKind.OpenKakko
				&& sf.testClass.includeMethodInTestCase(s + "(")) {
			MethodInTestCaseCalling.run(sf, s);
		}else if(s.equals(sf.target.getClassName())){
				if(sf.tokenArray.getKind(sf.index)==TokenKind.Word){
					throw new CannotUsingDoubleInstancesException(sf.tokenArray.get(sf.index).getLineNo(),sf.targetName);
				}
				TargetInvoke.staticRun(sf,sf.target);
			
		} else if (vt.include(s) || isVariable(sf, s)) {
			if (sf.target.getRawUndefinedValues().containsKey(s) && sf.tokenArray.getKind(sf.index)==TokenKind.Piriod) {
				TargetInvoke.run(sf, (TargetClass) vt.getVal(s));
			} else {
				CallingVariable.run(sf, s);
			}
		} else if (s.equals("{")) {
			Block.run(sf);
		} else if (s.equals("++")) {
			// Ou++
			Token t = tokenArray.getToken(sf.index++);
			VariableOrClassPush.run(sf, t.getVal());
			Object o = valueStack.pop();
			Object ro = SmallInterpreterSupportor.getIncOrDec(o, "+");
			vt.setVal(t.getVal(), ro);
			valueStack.push(ro);
		} else if (s.equals("--")) {
			// Ou--
			Token t = tokenArray.getToken(sf.index++);
			VariableOrClassPush.run(sf, t.getVal());
			Object o = valueStack.pop();
			Object ro = SmallInterpreterSupportor.getIncOrDec(o, "-");
			vt.setVal(t.getVal(), ro);
			valueStack.push(ro);
		} else if (s.equals("assertEquals")) {
			assertEq(sf);
		} else if (s.equals("assertTrue")) {
			assertTr(sf);
		} else if (s.equals("assertFalse")) {
			assertFl(sf);
		} else if (s.equals("assertNull")) {
			assertNl(sf);
		} else if (s.equals(targetName)) {
			TargetInvoke.run(sf, sf.target);
		} else if (s.equals("try")) {
			TryCatch.run(sf);
			if (tokenArray.getVal(sf.index).equals("finally")) {
				sf.index++;
				Block.run(sf);
				// tryJbRn܂悤ɌďĂ̂ŁAň߂B
				sf.index--;
			}
		} else if (s.equals("catch")) {
			IgnoreCatch.run(sf);
		} else if (s.equals("finally")) {
			sf.index++;
			Block.run(sf);
		} else if (s.equals("super")) {
			sf.index = tokenArray.indexOfVal(";", sf.index);
			sf.index++;
		} else if (s.equals("if")) {
			IfBlock.run(sf);
		} else if (s.equals("for")) {
			ForBlock.run(sf);
		} else if (s.equals("while")) {
			WhileBlock.run(sf);
		} else if (s.equals("break")) {
			Break.run(sf);
		} else if (s.equals("do")) {
			DoWhile.run(sf);
		} else if (s.equals("continue")) {
			Continue.run(sf);
		} else if (s.equals("return")) {
			// sf.index++;
			Expression.run(sf);
			throw new ReturnException();
		} else if (LangMgn.cannotUseThisReservedWordNow(s)) {
			throw new CannotUseThisTokenException(tokenArray.getToken(sf.index)
					.getLineNo(), s);
		} else if (tokenArray.getKind(sf.index - 1) == TokenKind.Word) {
			String str = isFullName(sf, s);
			if (str != null) {
				CallingVariable.run(sf, str);
			} else {
				Token t = tokenArray.getToken(sf.index - 1);
				throw new MaybeCannotCompileException(t.getLineNo(), t.getVal());
			}
		}
	}

	private static String isFullName(SharedFields sf, String s) {
		StringBuffer sb = new StringBuffer(s);
		Class c = null;
		for (int i = sf.index; i < sf.tokenArray.length(); i++) {
			if (sf.tokenArray.getKind(i) == TokenKind.Word) {
				sb.append(sf.tokenArray.getVal(i));
				c = sf.classNameResolver.getClazz(sb.toString());
				if (c != null) {
					sf.index = i + 1;
					return sb.toString();
				}
			} else if (sf.tokenArray.getKind(i) == TokenKind.Piriod) {
				sb.append(sf.tokenArray.getVal(i));
			} else {
				return null;
			}
		}
		return null;
	}

	protected static boolean isVariable(SharedFields sf, String s) {
		return SmallInterpreterSupportor.isVariable(sf.classNameResolver, s);
	}

	private static void assertEq(SharedFields sf) throws Exception {
		AssertEquals.run(sf);
	}

	private static void assertTr(SharedFields sf) throws Exception {
		AssertHelper.assertTr(sf);
		AssertEquals.runActual(sf);
	}

	private static void assertFl(SharedFields sf) throws Exception {
		AssertHelper.assertFl(sf);
		AssertEquals.runActual(sf);
	}

	private static void assertNl(SharedFields sf) throws Exception {
		AssertHelper.assertNl(sf);
		AssertEquals.runActual(sf);
	}
}
