package org.kikaineko.mock.analysis.innersi;

import java.lang.reflect.Array;
import java.util.Stack;

import org.kikaineko.mock.analysis.ClassNameResolver;
import org.kikaineko.mock.analysis.SmallInterpreterSupportor;
import org.kikaineko.mock.analysis.TypeOwner;
import org.kikaineko.mock.analysis.VariableTable;
import org.kikaineko.mock.analysis.exception.CannotUsingDoubleInstancesException;
import org.kikaineko.mock.analysis.exception.MaybeCannotCompileException;
import org.kikaineko.mock.framework.UndefinedValue;
import org.kikaineko.mock.util.Operator;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

public class Factor {

	public static void run(SharedFields sf) throws Exception {
		TokenArray tokenArray = sf.tokenArray;
		Stack valueStack = sf.valueStack;
		TypeOwner typeStack = sf.typeStack;
		VariableTable vt = sf.vt;
		ClassNameResolver classNameResolver = sf.classNameResolver;
		Token t = tokenArray.getToken(sf.index++);

		if (t.getKind() == TokenKind.Number) {
			sf.index = SmallInterpreterSupportor.numberPush(t, tokenArray,
					sf.index, valueStack, typeStack);
		} else if (t.getKind() == TokenKind.Word) {
			doWord(sf, t);
		} else if (t.getKind() == TokenKind.Minus) {
			Factor.run(sf);
			Object o = valueStack.pop();
			// type is not changed
			SmallInterpreterSupportor.negatePush(valueStack, o);
		} else if (t.getKind() == TokenKind.OpenKakko) {

			if (tokenArray.getVal(sf.index + 1).equals(")")) {
				// 1ǂ݂Kv
				Class c = classNameResolver.getClazz(tokenArray
						.getVal(sf.index));
				if (c != null) {
					Cast.run(sf, c);
				} else {
					Expression.run(sf);
					sf.index++;
				}
			} else {
				Expression.run(sf);
				sf.index++;
			}
		} else if (t.getKind() == TokenKind.DoubleQ) {
			if (tokenArray.getKind(sf.index) == TokenKind.DoubleQ) {
				// 󕶎̏ꍇ
				valueStack.push("");
			} else {
				valueStack.push(tokenArray.getVal(sf.index++));
			}
			typeStack.push(String.class);
			sf.index++;
		} else if (t.getKind() == TokenKind.SingleQ) {
			String s = tokenArray.getVal(sf.index++);
			char c = SmallInterpreterSupportor.toCharFromString(s);
			valueStack.push(new Character(c));
			typeStack.push(char.class);
			sf.index++;
		} else if (t.getKind() == TokenKind.Bikkuri) {
			Expression.run(sf);
			Object o = valueStack.pop();
			SmallInterpreterSupportor.negatePush(valueStack, o);
			// type is not changed
		} else if (t.getKind() == TokenKind.PP) {
			// Ou++
			Token tt = tokenArray.getToken(sf.index++);
			variableOrClassPush(sf, tt);
			Object o = valueStack.pop();
			Object ro = SmallInterpreterSupportor.getIncOrDec(o, "+");

			// ro = Operator.operate(new Integer(1), o, "+");
			vt.setVal(tt.getVal(), ro);
			valueStack.push(ro);
		} else if (t.getKind() == TokenKind.MM) {
			// Ou--
			Token tt = tokenArray.getToken(sf.index++);
			variableOrClassPush(sf, tt);
			Object o = valueStack.pop();
			Object ro = SmallInterpreterSupportor.getIncOrDec(o, "-");

			vt.setVal(tt.getVal(), ro);
			valueStack.push(ro);
		} else if (t.getKind() == TokenKind.Piriod) {
			sf.index = SmallInterpreterSupportor.numberPush(t, tokenArray,
					sf.index, valueStack, typeStack);
		}else if(t.getKind()==TokenKind.SemiKoron){
			return;
		} else {
			throw new MaybeCannotCompileException(t.getLineNo(), t.getVal());
		}
	}

	private static void constructor(SharedFields sf) throws Exception {
		MethodCalling.run(sf, "const");
	}

	private static void variableOrClassPush(SharedFields sf, Token t)
			throws CannotUsingDoubleInstancesException {
		variableOrClassPush(sf, t.getVal());
	}

	private static void variableOrClassPush(SharedFields sf, String s)
			throws CannotUsingDoubleInstancesException {
		if (sf.vt.include(s)) {
			sf.typeStack.push(sf.vt.getType(s));
			sf.valueStack.push(sf.vt.getVal(s));
		} else if (s.equals(sf.targetName)) {
			sf.typeStack.push(sf.target.getClass());
			sf.valueStack.push(sf.target);
		} else if (s.equals(sf.target.getClassName())) {
			throw new CannotUsingDoubleInstancesException(sf.tokenArray.get(
					sf.index).getLineNo(), sf.targetName);
		} else {
			// Class push
			Class c = sf.classNameResolver.getClazz(s);
			sf.typeStack.push(c);
			sf.valueStack.push(c);
		}
	}

	private static void doWord(SharedFields sf, Token t) throws Exception {
		TokenArray tokenArray = sf.tokenArray;
		Stack valueStack = sf.valueStack;
		TypeOwner typeStack = sf.typeStack;
		VariableTable vt = sf.vt;
		ClassNameResolver classNameResolver = sf.classNameResolver;
		String targetName = sf.targetName;

		if (tokenArray.getKind(sf.index) == TokenKind.OpenKakko
				&& sf.testClass.includeMethodInTestCase(t.getVal() + "(")) {
			MethodInTestCaseCalling.run(sf, t.getVal());
		} else if (t.getVal().equals(targetName)
				|| vt.include(t.getVal())
				|| SmallInterpreterSupportor.isVariable(classNameResolver, t
						.getVal())) {
			doVariable(sf, t);

		} else if (t.getVal().equals("true")) {
			valueStack.push(new Boolean(true));
			typeStack.push(boolean.class);
		} else if (t.getVal().equals("false")) {
			valueStack.push(new Boolean(false));
			typeStack.push(boolean.class);
		} else if (t.getVal().equals("new")) {
			if (tokenArray.getVal(sf.index + 1).equals("[")) {
				ArrayGenerate.run(sf);
			} else {
				constructor(sf);
			}
		} else if (t.getVal().equals("null")) {
			valueStack.push(null);
			typeStack.push(Object.class);
		} else if (t.getVal().equals(targetName)) {
			// ŁAsľ^ϐm邱Ƃ͓̂
			// L蓾Ȃsl쐬Ă
			UndefinedValue undefV = UndefinedValue
					.getCompornent(void.class, "");
			TargetInvokingForUndefinedValue.run(sf, undefV, sf.target);

		} else if (LangMgn.isPremit(t.getVal())) {
			if (tokenArray.getVal(sf.index + 1).equals("class")) {
				sf.index++;
				sf.index++;
				valueStack.push(LangMgn.getPremitClass(t.getVal()));
				typeStack.push(Class.class);
			} else {
				throw new MaybeCannotCompileException(tokenArray.getToken(
						sf.index + 1).getLineNo(), tokenArray
						.getVal(sf.index + 1));
			}
		} else if (t.getKind() == TokenKind.Word && sf.classNameResolver.isStaticImport(t.getVal())) {
			StaticImportPartInvoke.run(sf,t.getVal());
		} else if (t.getKind() == TokenKind.Word) {
			// ϐ͂ɂ͂Ȃ
			// 肦̂̓NX̃tl[ł
			Class c = isFullName(sf, t);
			sf.typeStack.push(c);
			sf.valueStack.push(c);
		}
	}

	private static Class isFullName(SharedFields sf, Token t) {
		StringBuffer sb = new StringBuffer(t.getVal());
		Class c = null;
		for (int i = sf.index; i < sf.tokenArray.length(); i++) {
			if (sf.tokenArray.getKind(i) == TokenKind.Word) {
				sb.append(sf.tokenArray.getVal(i));
				c = sf.classNameResolver.getClazz(sb.toString());
				if (c != null) {
					sf.index = i + 1;
					return c;
				}
			} else if (sf.tokenArray.getKind(i) == TokenKind.Piriod) {
				sb.append(sf.tokenArray.getVal(i));
			} else {
				return null;
			}
		}
		return null;
	}

	private static void doVariable(SharedFields sf, Token t) throws Exception {
		TokenArray tokenArray = sf.tokenArray;
		Stack valueStack = sf.valueStack;
		TypeOwner typeStack = sf.typeStack;
		VariableTable vt = sf.vt;
		variableOrClassPush(sf, t);

		if (tokenArray.getVal(sf.index).equals("[")) {
			Object contents = valueStack.pop();
			typeStack.pop();

			sf.index++; // [
			Expression.run(sf);
			int index = ((Number) valueStack.pop()).intValue();
			typeStack.pop();
			sf.index++; // ]

			contents = Array.get(contents, index);
			while (tokenArray.getKind(sf.index) == TokenKind.ArrayOpen) {
				sf.index++; // [
				Expression.run(sf);
				index = ((Number) valueStack.pop()).intValue();
				typeStack.pop();
				sf.index++;// ]
				contents = Array.get(contents, index);
			}

			valueStack.push(contents);
			typeStack.push(contents.getClass());

		} else if (tokenArray.getVal(sf.index).equals("++")) {
			sf.index++;

			Object o = valueStack.peek();
			Object ro = null;
			if (o.getClass() == Byte.class) {
				ro = Operator.operate(new Byte((byte) 1), o, "+");
			} else if (o.getClass() == Short.class) {
				ro = Operator.operate(new Short((short) 1), o, "+");
			} else {
				ro = Operator.operate(new Integer(1), o, "+");
			}

			vt.setVal(t.getVal(), ro);
		} else if (tokenArray.getVal(sf.index).equals("--")) {
			sf.index++;
			Object o = valueStack.peek();
			Object ro = null;
			if (o.getClass() == Byte.class) {
				ro = Operator.operate(new Byte((byte) 1), o, "-");
			} else if (o.getClass() == Short.class) {
				ro = Operator.operate(new Short((short) 1), o, "-");
			} else {
				ro = Operator.operate(new Integer(1), o, "-");
			}
			vt.setVal(t.getVal(), ro);
		}
	}
}
